/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.network;

import com.helpsystems.common.core.network.AbstractBusinessObject;
import com.helpsystems.common.core.network.DataReplicationEntry;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.XMLUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DataReplicationRequest
extends AbstractBusinessObject {
    private static final long serialVersionUID = -3562213205159532490L;
    public static final int TABLE_NAME_MAX_LENGTH = 10;
    public static final int PRODUCT_NAME_MAX_LENGTH = 10;
    public static final int PRODUCT_RELEASE_MAX_LENGTH = 3;
    public static final int PIID_FIELD_NAME_MAX_LENGTH = 25;
    public static final int LIBRARY_NAME_MAX_LENGTH = 10;
    public static final int INSERT = 1;
    public static final int UPDATE = 2;
    public static final int DELETE = 3;
    public static final int REPLICATION = 1;
    public static final int LEGACY = 2;
    public static final Collection VALID_CHANGE_TYPE_CODES;
    public static final Map CHANGE_TYPE_MAPPINGS;
    private String productName;
    private String productRelease;
    private String tableName;
    private int changeType;
    private String libraryName;
    private int nodeProductIID;
    private String piidFieldName;
    private long newCode;
    private int changeCode;
    private int requestMode;
    private ArrayList<DataReplicationEntry> entries = new ArrayList();
    private boolean processedByHost;

    public void addEntry(DataReplicationEntry dataReplicationEntry) {
        this.entries.add(dataReplicationEntry);
    }

    public static void addEntry(DataReplicationRequest dataReplicationRequest, String string, String string2) {
        DataReplicationEntry dataReplicationEntry = new DataReplicationEntry();
        dataReplicationEntry.setColumnName(string);
        dataReplicationEntry.setNewValue(string2);
        dataReplicationRequest.addEntry(dataReplicationEntry);
    }

    public int getChangeType() {
        return this.changeType;
    }

    public int getRequestMode() {
        return this.requestMode;
    }

    public long getNewCode() {
        return this.newCode;
    }

    public int getChangeCode() {
        return this.changeCode;
    }

    public DataReplicationEntry[] getEntries() {
        DataReplicationEntry[] dataReplicationEntryArray = new DataReplicationEntry[this.entries.size()];
        this.entries.toArray(dataReplicationEntryArray);
        return dataReplicationEntryArray;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductRelease() {
        return this.productRelease;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public int getNodeProductIID() {
        return this.nodeProductIID;
    }

    public String getPiidFieldName() {
        return this.piidFieldName;
    }

    public boolean isProcessedByHost() {
        return this.processedByHost;
    }

    public void removeAllEntries() {
        this.entries.clear();
    }

    public void setChangeType(int n) {
        if (!VALID_CHANGE_TYPE_CODES.contains(new Integer(n))) {
            throw new IllegalArgumentException("The specified change type is not valid: " + n);
        }
        this.changeType = n;
    }

    public void setChangeType(char c) {
        Integer n = (Integer)CHANGE_TYPE_MAPPINGS.get(new Character(Character.toUpperCase(c)));
        if (n == null) {
            throw new IllegalArgumentException("The specified change type is not valid: " + c);
        }
        this.setChangeType(n);
    }

    public void setRequestMode(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("The specified request mode is not valid.");
        }
        this.requestMode = n;
    }

    public void setNewCode(long l) {
        this.newCode = l;
    }

    public void setChangeCode(int n) {
        this.changeCode = n;
    }

    public void setProcessedByHost(boolean bl) {
        this.processedByHost = bl;
    }

    public void setTableName(String string) throws IllegalArgumentException {
        ValidationHelper.validateLength("Table name", 10, string);
        this.tableName = string;
    }

    public void setProductName(String string) throws IllegalArgumentException {
        ValidationHelper.validateLength("Product name", 10, string);
        this.productName = string;
    }

    public void setProductRelease(String string) throws IllegalArgumentException {
        ValidationHelper.validateLength("Product release", 3, string);
        this.productRelease = string;
    }

    public void setLibraryName(String string) throws IllegalArgumentException {
        ValidationHelper.validateLength("Library Name", 10, string);
        this.libraryName = string;
    }

    public void setNodeProductIID(int n) throws IllegalArgumentException {
        this.nodeProductIID = n;
    }

    public void setPiidFieldName(String string) throws IllegalArgumentException {
        if (string != null) {
            ValidationHelper.validateLength("Product instance ID field name", 25, string);
            this.piidFieldName = string;
        }
    }

    public void setXMLData(String string) throws IOException {
        try {
            Document document = XMLUtil.stringToDocument(string);
            if (document == null) {
                throw new NullPointerException("Unable to convert the XML Data into an XML Document");
            }
            this.setXMLData(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException("ParserConfigurationException when processing the XML data.");
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException("SAXException when processing the XML data.");
            iOException.initCause(sAXException);
            throw iOException;
        }
    }

    public void setXMLData(Document document) throws IOException {
        this.parseDocument(document);
    }

    protected void parseDocument(Document document) {
        String string;
        if (document == null) {
            throw new NullPointerException("The XML passed in is null.");
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            throw new NullPointerException("The document is empty/null.");
        }
        String string2 = element.getNodeName();
        if (!"data-replication".equalsIgnoreCase(string2)) {
            throw new RuntimeException("The first node in the Document was " + string2 + ". It should be 'data-replication'");
        }
        String string3 = element.getAttribute("oid");
        if (string3 != null && string3.length() > 0) {
            try {
                this.setObjectIDInt(Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("The OID is not a valid number.");
            }
        }
        if ((string = element.getAttribute("table")) == null || string.length() == 0) {
            throw new NullPointerException("The table name is null.");
        }
        this.setTableName(string);
        String string4 = element.getAttribute("product-name");
        if (string4 == null || string4.length() == 0) {
            throw new NullPointerException("The product name is null.");
        }
        this.setProductName(string4);
        String string5 = element.getAttribute("product-release");
        if (string5 == null || string5.length() == 0) {
            throw new NullPointerException("The product release is null.");
        }
        this.setProductRelease(string5);
        String string6 = element.getAttribute("node-library");
        if (string6 == null || string6.length() == 0) {
            throw new NullPointerException("The node library name is null.");
        }
        this.setLibraryName(string6);
        String string7 = element.getAttribute("piid-field");
        if (string7 == null || string7.length() == 0) {
            throw new NullPointerException("The product instance ID field name is null.");
        }
        this.setPiidFieldName(string7);
        String string8 = element.getAttribute("type");
        if (string8 == null || string8.length() == 0) {
            throw new NullPointerException("The change type is null.");
        }
        this.setChangeType(string8.charAt(0));
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string9;
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !"column".equalsIgnoreCase((element2 = (Element)node).getNodeName())) continue;
            String string10 = element2.getAttribute("name");
            if (string10 == null || string10.length() == 0) {
                throw new NullPointerException("A column entry for OID " + string3 + " contains a null column name.");
            }
            DataReplicationEntry dataReplicationEntry = new DataReplicationEntry();
            dataReplicationEntry.setColumnName(string10);
            boolean bl = false;
            try {
                string9 = element2.getAttribute("hexmode");
                bl = string9.equalsIgnoreCase("true");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                String string11;
                string9 = element2.getAttribute("old");
                if (string9 != null && string9.length() > 0) {
                    dataReplicationEntry.setOriginalValue(this.decodeHexValue(string9));
                }
                if ((string11 = element2.getAttribute("new")) != null && string11.length() > 0) {
                    dataReplicationEntry.setNewValue(this.decodeHexValue(string11));
                }
                dataReplicationEntry.setEncoded(true);
            } else {
                dataReplicationEntry.setOriginalValue(element2.getAttribute("old"));
                dataReplicationEntry.setNewValue(element2.getAttribute("new"));
            }
            this.addEntry(dataReplicationEntry);
        }
    }

    private String decodeHexValue(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
        }
        return new String(byArray);
    }

    public void clearEntries() {
        this.entries.clear();
    }

    @Override
    public boolean equals(Object object) {
        if (this.getClass().equals(object.getClass())) {
            return this.equals((DataReplicationRequest)object);
        }
        return false;
    }

    public boolean equals(DataReplicationRequest dataReplicationRequest) {
        return this.isSimilar(dataReplicationRequest) && this.getEntries().equals(dataReplicationRequest.getEntries()) && this.getChangeCode() == dataReplicationRequest.getChangeCode() && this.getNewCode() == dataReplicationRequest.getNewCode();
    }

    public boolean isSimilar(DataReplicationRequest dataReplicationRequest) {
        return super.equals(dataReplicationRequest) && this.getTableName().equals(dataReplicationRequest.getTableName()) && this.getProductName().equals(dataReplicationRequest.getProductName()) && this.getProductRelease().equals(dataReplicationRequest.getProductRelease()) && this.getLibraryName().equals(dataReplicationRequest.getLibraryName()) && this.getNodeProductIID() == dataReplicationRequest.getNodeProductIID() && this.getPiidFieldName().equals(dataReplicationRequest.getPiidFieldName()) && this.getChangeType() == dataReplicationRequest.getChangeType() && this.getRequestMode() == dataReplicationRequest.getRequestMode() && this.isProcessedByHost() == dataReplicationRequest.isProcessedByHost();
    }

    static {
        HashMap<Character, Integer> hashMap = new HashMap<Character, Integer>(3);
        hashMap.put(new Character('D'), new Integer(3));
        hashMap.put(new Character('I'), new Integer(1));
        hashMap.put(new Character('U'), new Integer(2));
        VALID_CHANGE_TYPE_CODES = Collections.unmodifiableCollection(hashMap.values());
        CHANGE_TYPE_MAPPINGS = Collections.unmodifiableMap(hashMap);
    }
}

