/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.encryption;

import com.helpsystems.common.core.util.ValidationHelper;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class MD5 {
    public static long hashTextToLong(String string) throws NoSuchAlgorithmException {
        byte[] byArray = MD5.hashTextToByte(string);
        return MD5.byteToLong(byArray);
    }

    public static String hashText(String string) throws NoSuchAlgorithmException {
        byte[] byArray = MD5.hashTextToByte(string);
        return MD5.byteToHex(byArray);
    }

    private static byte[] hashTextToByte(String string) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        byte[] byArray = string.getBytes();
        messageDigest.update(byArray, 0, byArray.length);
        byte[] byArray2 = messageDigest.digest();
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hashFile(String string) throws IOException, NoSuchAlgorithmException {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = new byte[1500];
            int n = fileInputStream.read(byArray);
            while (n != -1) {
                messageDigest.update(byArray, 0, n);
                n = fileInputStream.read(byArray);
            }
            byte[] byArray2 = messageDigest.digest();
            String string2 = MD5.byteToHex(byArray2);
            return string2;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private static String byteToHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if ((byArray[i] & 0xFF) < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF));
        }
        return stringBuffer.toString();
    }

    private static long byteToLong(byte[] byArray) {
        int n = 0;
        if (byArray.length > 8) {
            n = byArray.length - 8;
        }
        long l = MD5.unsignedByte(byArray[n]);
        for (int i = n + 1; i < byArray.length; ++i) {
            l = l << 8 | (long)MD5.unsignedByte(byArray[i]);
        }
        return l;
    }

    public static int unsignedByte(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        return n2;
    }

    public static String shortHash(String string) throws NoSuchAlgorithmException {
        if (string != null && MD5.verifyShortHash(string)) {
            return string;
        }
        long l = MD5.hashTextToLong(string);
        long l2 = (long)Math.sqrt(Math.abs(l));
        l = l2 << 8;
        int n = 0;
        while (l2 > 0L) {
            int n2 = (int)(l2 - l2 / 10L * 10L);
            n += n2;
            l2 /= 10L;
        }
        StringBuffer stringBuffer = new StringBuffer(Long.toHexString(l |= (long)(n &= 0xFF) & 0xFFFFFFFFFFL));
        while (stringBuffer.length() < 10) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    public static boolean verifyShortHash(String string) {
        int n;
        ValidationHelper.checkForNullAndBlank("Hash code", string);
        if (string.length() != 10) {
            return false;
        }
        try {
            n = Integer.parseInt(string.substring(8), 16);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        int n2 = 0;
        for (long i = Long.parseLong(string.substring(0, 8), 16); i > 0L; i /= 10L) {
            int n3 = (int)(i - i / 10L * 10L);
            n2 += n3;
        }
        return (n2 &= 0xFF) == n;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("Usage: ");
            System.out.println("\tMD5 somefilename: encode a file's contents (md5sum)");
            System.out.println("\tMD5 - some words: encode the words on the command line.");
            return;
        }
        if (stringArray[0].equals("-") && stringArray.length > 1) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 1; i < stringArray.length; ++i) {
                if (i > 1) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(stringArray[i]);
            }
            System.out.println("String: " + MD5.hashText(stringBuffer.toString()));
            System.out.println("Number: " + Long.toHexString(MD5.hashTextToLong(stringBuffer.toString())));
        } else {
            System.out.println(MD5.hashFile(stringArray[0]));
        }
    }
}

