/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.busobj.Identifiable;
import com.helpsystems.common.core.busobj.VersionedObject;
import com.helpsystems.common.core.filter.GenericSortField;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.core.network.ProductIID;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.TargetVersionInfo;
import com.helpsystems.common.core.util.ValidationHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class Proxy
extends CommonVersionedObject
implements Identifiable,
Cloneable {
    private static final Logger logger = Logger.getLogger(Proxy.class);
    public static final int SORT_NAME = 10101;
    public static final int SORT_DESCRIPTION = 20202;
    private static final long serialVersionUID = 110022003300440055L;
    private static HashMap<String, PacketElementInfo> packetElementInfoMap = new HashMap();
    private String name = "";
    private String description = "";
    private Object key = null;
    private BasicIdentifier myId;
    private transient ArrayList<String> badMethodList = new ArrayList();

    public Proxy() {
        this.addDoNotInvoke("getProductIID");
        this.addDoNotInvoke("getProductIIDInt");
    }

    protected void addDoNotInvoke(String string) {
        this.badMethodList.add(string);
    }

    @Override
    public BasicIdentifier getIdentifier() {
        return this.myId;
    }

    @Override
    public void setIdentifier(BasicIdentifier basicIdentifier) {
        this.myId = basicIdentifier;
    }

    public Comparator<Proxy> getComparator(SortField sortField) {
        return this.getComparator(sortField, true);
    }

    public Comparator<Proxy> getComparator(SortField sortField, boolean bl) {
        ValidationHelper.checkForNull("SortField", sortField);
        int n = sortField.getField();
        if (n == 10101 || n == 20202) {
            return new ProxyComparator(sortField, bl);
        }
        throw new IllegalArgumentException("The sort field index " + n + " is not valid in class " + this.getClass().getName());
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public ProductIID getProductIID() {
        if (this.myId != null && this.myId instanceof ProductIID) {
            return (ProductIID)this.myId;
        }
        return null;
    }

    public final String[] doNotInvoke() {
        String[] stringArray = new String[this.badMethodList.size()];
        this.badMethodList.toArray(stringArray);
        return stringArray;
    }

    public int getProductIIDInt() {
        if (this.myId != null && this.myId instanceof ProductIID) {
            return ((ProductIID)this.myId).getID();
        }
        return 0;
    }

    public Object getKey() {
        if (this.key == null) {
            return this.getName();
        }
        return this.key;
    }

    public void setName(String string) {
        ValidationHelper.checkForNull("Name", string);
        this.name = string;
    }

    public void setDescription(String string) {
        ValidationHelper.checkForNull("Description", string);
        this.description = string;
    }

    public void setProductIIDInt(int n) {
        this.setIdentifier(new ProductIID(n));
    }

    public void setKey(Object object) {
        this.key = object;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof Proxy)) {
            return false;
        }
        Proxy proxy = (Proxy)object;
        return Equal.isEqual(proxy.name, this.name) && Equal.isEqual(proxy.description, this.description) && Equal.isEqual(proxy.myId, this.myId) && Equal.isEqual(proxy.key, this.key);
    }

    public static void sort(Proxy[] proxyArray, SortField sortField) {
        SortField sortField2 = sortField;
        if (sortField2 == null) {
            sortField2 = new GenericSortField(10101, 0);
        }
        ProxyComparator proxyComparator = new ProxyComparator(sortField2, true);
        Arrays.sort(proxyArray, proxyComparator);
    }

    protected static void setPacketElementInfo(Class clazz, String string, String string2) {
        packetElementInfoMap.put(clazz.getName(), new PacketElementInfo(string, string2));
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(">>> Proxy now knows that a " + clazz.getName() + " is a [" + string + "]"));
        }
    }

    public static String getPacketElementType(Object object) {
        PacketElementInfo packetElementInfo;
        String string = object.getClass().getName();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(">>> Proxy getting element type of a " + string + "..."));
        }
        if ((packetElementInfo = packetElementInfoMap.get(string)) != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(">>> Proxy recognized that a " + string + " is a [" + packetElementInfo.type + "]"));
            }
            return packetElementInfo.type;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(">>> Proxy didn't recognize a " + string));
        }
        return "Unknown Object Type";
    }

    public static String getPacketElementDescription(Object object) {
        Proxy proxy = (Proxy)object;
        return proxy.getName();
    }

    @Override
    protected void adjustForReading(TargetVersionInfo targetVersionInfo, VersionedObject.ObjectFieldMap objectFieldMap) throws IOException {
    }

    @Override
    protected void adjustForWriting(TargetVersionInfo targetVersionInfo, VersionedObject.ObjectFieldMap objectFieldMap) throws IOException {
    }

    public String toString() {
        return "common.core.busobj.Proxy [key=" + this.getKey() + ", name=" + this.getName() + ", desc=" + this.getDescription() + ", obj=" + super.toString() + "]";
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Unable to clone this instance.");
        }
    }

    private static class PacketElementInfo {
        String type;
        String description;

        PacketElementInfo(String string, String string2) {
            this.type = string;
            this.description = string2;
        }
    }

    private static class ProxyComparator
    implements Comparator<Proxy> {
        SortField sort;
        boolean caseSensitive;

        ProxyComparator(SortField sortField, boolean bl) {
            this.sort = sortField;
            this.caseSensitive = bl;
        }

        @Override
        public int compare(Proxy proxy, Proxy proxy2) {
            String string = null;
            String string2 = null;
            if (this.sort.getField() == 10101) {
                string = this.upperCaseIfNeeded(proxy.getName());
                string2 = this.upperCaseIfNeeded(proxy2.getName());
            } else if (this.sort.getField() == 20202) {
                string = this.upperCaseIfNeeded(proxy.getDescription());
                string2 = this.upperCaseIfNeeded(proxy2.getDescription());
            }
            if (string == null) {
                string = "";
            }
            if (string2 == null) {
                string2 = "";
            }
            if (this.sort.isAscending()) {
                return string.compareTo(string2);
            }
            return string2.compareTo(string);
        }

        private String upperCaseIfNeeded(String string) {
            if (string == null) {
                return string;
            }
            if (!this.caseSensitive) {
                return string.toUpperCase();
            }
            return string;
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }
    }
}

