/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access.dataset;

import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.dataset.NotifyingDataSetProducer;
import com.helpsystems.common.core.filter.SortField;
import java.util.EventObject;

public class NotifyingDSPEvent
extends EventObject {
    public static final int SUCCESSFUL = 1;
    public static final int FAILURE = -1;
    public static final int UNKNOWN = 0;
    public static final int FAILURE_REPORTED = -2;
    private boolean isConsumed = false;
    private SortField sortField = null;
    private DataSet dataSet = null;
    private int eventCode = 0;
    private Exception eventException = null;
    private String eventSourceName = null;

    public NotifyingDSPEvent(NotifyingDataSetProducer notifyingDataSetProducer, DataSet dataSet, SortField sortField) {
        this(notifyingDataSetProducer, dataSet, sortField, 0, null);
    }

    public NotifyingDSPEvent(NotifyingDataSetProducer notifyingDataSetProducer, DataSet dataSet, SortField sortField, int n) {
        this(notifyingDataSetProducer, dataSet, sortField, n, null);
    }

    public NotifyingDSPEvent(NotifyingDataSetProducer notifyingDataSetProducer, DataSet dataSet, SortField sortField, int n, Exception exception) {
        this(notifyingDataSetProducer, dataSet, sortField, n, exception, null);
    }

    public NotifyingDSPEvent(NotifyingDataSetProducer notifyingDataSetProducer, DataSet dataSet, SortField sortField, int n, Exception exception, String string) {
        super(notifyingDataSetProducer);
        this.eventException = exception;
        this.eventCode = n;
        this.dataSet = dataSet;
        this.sortField = sortField;
        this.eventSourceName = string;
    }

    public void consume() {
        this.isConsumed = true;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public SortField getSortField() {
        return this.sortField;
    }

    public boolean isConsumed() {
        return this.isConsumed;
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public Exception getEventException() {
        return this.eventException;
    }

    public String getEventSourceName() {
        return this.eventSourceName;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("NotifyingDSPEvent [");
        stringBuffer.append("dataSet=" + this.dataSet + ", size=");
        try {
            stringBuffer.append(this.dataSet.size());
        }
        catch (DataSetException dataSetException) {
            stringBuffer.append("unknown (Exception: '" + dataSetException.getMessage() + "')");
        }
        stringBuffer.append(", source=" + this.source);
        stringBuffer.append(", sortField=(" + this.sortField.getField());
        stringBuffer.append(", order=" + (this.sortField.isAscending() ? "asc." : "desc.") + ")");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

