/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access.dataset;

import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ErrorTable;
import com.helpsystems.common.core.access.dataset.ArrayDataSet;
import com.helpsystems.common.core.access.dataset.DataSetClosedException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class CachingDataSet<T>
implements DataSet<T>,
Iterable<T> {
    private static final Logger logger = Logger.getLogger(CachingDataSet.class);
    private DataSet<T> dataSet;
    private HashMap<Integer, Object> cacheMap;
    private TreeMap<Long, Object> expirationTree;
    private long counter;
    private Object NULL_PLACEHOLDER = new Object();
    private int blockSize;
    private int maxEntries;
    private int size = -1;
    private boolean isClosed = true;
    private Object lockObject;

    public CachingDataSet(DataSet dataSet) throws DataSetException {
        this(dataSet, 200, 2000);
    }

    public CachingDataSet(DataSet<T> dataSet, int n, int n2) throws DataSetException {
        if (dataSet == null) {
            throw new NullPointerException("The DataSet passed in is null.");
        }
        this.dataSet = dataSet;
        this.size = dataSet.size();
        logger.trace((Object)("CachingDataSet size is " + this.size));
        this.blockSize = n;
        this.maxEntries = n2 > 0 && n2 < n ? 10 * n : n2;
        this.cacheMap = n2 > 0 ? new HashMap((int)((double)n2 * 1.25)) : new HashMap(1000);
        this.expirationTree = new TreeMap();
        this.lockObject = new Object();
        this.isClosed = false;
    }

    protected void checkIfClosed() throws DataSetClosedException {
        if (this.isClosed) {
            throw new DataSetClosedException("The DataSet is closed.");
        }
    }

    void initialize(int n) {
        this.size = n;
        this.cacheMap.clear();
        this.expirationTree.clear();
    }

    @Override
    public void close() throws DataSetException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.cacheMap.clear();
        this.expirationTree.clear();
        this.dataSet.close();
    }

    public T get(int n) throws DataSetException, BadDataException {
        if (this.isArrayDataSet()) {
            return ((ArrayDataSet)this.dataSet).get(n);
        }
        if (!this.isInCache(n)) {
            this.checkIfClosed();
        }
        try {
            T[] TArray = this.get(n, 1);
            if (TArray == null || TArray.length == 0) {
                return null;
            }
            return TArray[0];
        }
        catch (BadDataArrayException badDataArrayException) {
            Integer n2 = new Integer(n);
            HashMap<Integer, Object> hashMap = this.cacheMap;
            synchronized (hashMap) {
                throw (BadDataException)this.cacheMap.get(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T[] get(int n, int n2) throws DataSetException, BadDataArrayException {
        Object object;
        int n3;
        HashMap<Integer, Object> hashMap;
        int n4;
        if (this.isArrayDataSet()) {
            return this.dataSet.get(n, n2);
        }
        Object[] objectArray = new Object[n2];
        boolean bl = false;
        HashMap<Integer, Object> hashMap2 = this.cacheMap;
        synchronized (hashMap2) {
            for (n4 = 0; n4 < n2; ++n4) {
                Object object2 = this.cacheMap.get(new Integer(n4 + n));
                if (object2 == null) {
                    bl = true;
                    if (!logger.isTraceEnabled()) break;
                    logger.trace((Object)("CachingDataSet miss, Requested offset = " + n + "  length = " + n2));
                    break;
                }
                objectArray[n4] = object2;
            }
        }
        if (!bl) {
            return this.translateData(objectArray, n);
        }
        this.checkIfClosed();
        int n5 = n4 + n;
        int n6 = n2 - n4;
        HashMap<Integer, Object> hashMap3 = this.cacheMap;
        synchronized (hashMap3) {
            int n7;
            while ((hashMap = this.cacheMap.get(new Integer(n7 = n5 + n6 - 1))) != null) {
                objectArray[n7 - n] = hashMap;
                --n6;
            }
        }
        boolean bl2 = false;
        while (n6 < this.blockSize) {
            bl2 = false;
            if (n5 > 0 && this.cacheMap.get(new Integer(n5 - 1)) == null) {
                --n5;
                ++n6;
                bl2 = true;
            }
            if (n6 < this.blockSize && n6 + n5 < this.size && this.cacheMap.get(new Integer(n6 + n5)) == null) {
                ++n6;
                bl2 = true;
            }
            if (bl2) continue;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("\tCachingDataSet adjusted: offset = " + n5 + " \t length = " + n6));
        }
        Object[] objectArray2 = null;
        try {
            objectArray2 = this.dataSet.get(n5, n6);
        }
        catch (BadDataArrayException badDataArrayException) {
            objectArray2 = badDataArrayException.getArray();
            for (n3 = 0; n3 < objectArray2.length; ++n3) {
                object = badDataArrayException.createBadDataException(n3);
                if (object == null) continue;
                objectArray2[n3] = object;
            }
        }
        catch (DataSetClosedException dataSetClosedException) {
            this.isClosed = true;
            throw dataSetClosedException;
        }
        hashMap = this.cacheMap;
        synchronized (hashMap) {
            for (n3 = 0; n3 < objectArray2.length; ++n3) {
                object = objectArray2[n3];
                if (object == null) {
                    object = this.NULL_PLACEHOLDER;
                }
                Integer n8 = new Integer(n3 + n5);
                this.put(n8, object);
                int n9 = n3 + n5 - n;
                if (n9 <= -1 || n9 >= objectArray.length) continue;
                objectArray[n9] = object;
            }
        }
        return this.translateData(objectArray, n);
    }

    private Object[] translateData(Object[] objectArray, int n) throws BadDataArrayException {
        Object[] objectArray2 = new Object[objectArray.length];
        ErrorTable errorTable = null;
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object = objectArray[i];
            if (object == null) {
                throw new NullPointerException("Cache inconsistency at row " + (i + n) + ": null value.");
            }
            if (object instanceof BadDataException) {
                BadDataException badDataException = (BadDataException)object;
                objectArray2[i] = badDataException.getLoadedObject();
                if (errorTable == null) {
                    errorTable = new ErrorTable();
                }
                ErrorList errorList = badDataException.getErrorList();
                errorTable.addExceptions(i, errorList);
                continue;
            }
            objectArray2[i] = object == this.NULL_PLACEHOLDER ? null : object;
        }
        if (errorTable != null) {
            throw new BadDataArrayException("One or more objects contains bad data.", objectArray2, errorTable);
        }
        return objectArray2;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getMaximumEntries() {
        return this.maxEntries;
    }

    public DataSet getWrappedDataSet() {
        return this.dataSet;
    }

    public boolean isInCache(int n) {
        if (this.isArrayDataSet()) {
            return true;
        }
        return this.cacheMap.get(new Integer(n)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeAnEntry() {
        Object object = this.lockObject;
        synchronized (object) {
            Long l = this.expirationTree.firstKey();
            Object object2 = this.expirationTree.remove(l);
            this.cacheMap.remove(object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(Integer n, Object object) {
        Object object2 = this.lockObject;
        synchronized (object2) {
            if (this.maxEntries > 0 && this.cacheMap.size() > this.maxEntries) {
                this.purgeAnEntry();
            }
            this.cacheMap.put(n, object);
            ++this.counter;
            this.expirationTree.put(new Long(this.counter), n);
        }
    }

    public void setBlockSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("The block size " + n + " is not valid.");
        }
        this.blockSize = n;
    }

    @Override
    public int size() {
        if (this.isClosed) {
            return -1;
        }
        return this.size;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private boolean isArrayDataSet() {
        if (this.dataSet == null) {
            return false;
        }
        return this.dataSet instanceof ArrayDataSet;
    }

    @Override
    public Iterator<T> iterator() {
        return new DataSetIterator();
    }

    class DataSetIterator
    implements Iterator<T> {
        private int index = -1;

        DataSetIterator() {
        }

        @Override
        public boolean hasNext() {
            if (CachingDataSet.this.isClosed()) {
                return false;
            }
            return this.index + 1 < CachingDataSet.this.size();
        }

        @Override
        public T next() {
            ++this.index;
            try {
                return CachingDataSet.this.get(this.index);
            }
            catch (DataSetException dataSetException) {
                throw new RuntimeException("Unable to retrieve next object.", dataSetException);
            }
            catch (BadDataException badDataException) {
                throw new RuntimeException("Object contains bad data.", badDataException);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not allowed");
        }
    }
}

