/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access.dataset;

import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ErrorTable;
import com.helpsystems.common.core.access.dataset.DataSetList;
import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.ValidationHelper;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;

public class ArrayDataSet<T>
extends CommonVersionedObject
implements DataSet {
    private static final long serialVersionUID = -6356987952240966799L;
    private Comparator comparator = null;
    private T[] array;

    public ArrayDataSet() {
    }

    public ArrayDataSet(T[] TArray) {
        this.array = TArray;
    }

    @Override
    public void close() {
    }

    public static DataSet checkThreshold(DataSet dataSet, int n) throws DataSetException {
        if (dataSet == null) {
            throw new NullPointerException("The source passed in is null.");
        }
        if (dataSet.size() > n) {
            return dataSet;
        }
        DataSet dataSet2 = ArrayDataSet.createDataSet(dataSet);
        dataSet.close();
        return dataSet2;
    }

    public static DataSet createDataSet(DataSet dataSet) throws DataSetException {
        if (dataSet == null) {
            throw new NullPointerException("The source passed in is null.");
        }
        if (dataSet.size() == 0) {
            return new ArrayDataSet<Object>(new Object[0]);
        }
        Object[] objectArray = null;
        try {
            objectArray = dataSet.get(0, dataSet.size());
        }
        catch (BadDataArrayException badDataArrayException) {
            Object[] objectArray2 = badDataArrayException.getArray();
            objectArray = new Object[objectArray2.length];
            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            ErrorTable errorTable = badDataArrayException.getErrors();
            for (int i = 0; i < objectArray.length; ++i) {
                ErrorList errorList = errorTable.getErrorsForIndex(i);
                if (errorList == null) continue;
                objectArray[i] = new BadDataException("Error loading this object.", objectArray[i], errorList);
            }
        }
        return new ArrayDataSet(objectArray);
    }

    @Override
    public T[] get(int n, int n2) throws DataSetException, BadDataArrayException {
        Object[] objectArray = new Object[n2];
        ErrorTable errorTable = new ErrorTable();
        for (int i = 0; i < n2; ++i) {
            T t = this.array[i + n];
            if (t instanceof BadDataException) {
                BadDataException badDataException = (BadDataException)t;
                objectArray[i] = badDataException.getLoadedObject();
                errorTable.addException(i, badDataException);
                continue;
            }
            objectArray[i] = t;
        }
        if (errorTable.getBadObjectCount() > 0) {
            throw new BadDataArrayException("One or more of the objects contained bad data.", objectArray, errorTable);
        }
        return objectArray;
    }

    public T get(int n) throws DataSetException, BadDataException {
        try {
            T[] TArray = this.get(n, 1);
            if (TArray == null || TArray.length == 0) {
                return null;
            }
            return TArray[0];
        }
        catch (BadDataArrayException badDataArrayException) {
            BadDataException badDataException = badDataArrayException.createBadDataException(0);
            throw badDataException;
        }
    }

    @Override
    public int size() {
        return this.array.length;
    }

    public static Object[] toArray(DataSet dataSet, boolean bl) throws DataSetException, BadDataException {
        ValidationHelper.checkForNull("Data Set", dataSet);
        if (dataSet.size() == 0) {
            if (bl) {
                try {
                    dataSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new Object[0];
        }
        DataSetList dataSetList = new DataSetList(dataSet);
        Object t = dataSetList.get(0);
        Class clazz = Object.class;
        if (t != null) {
            clazz = t.getClass();
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, dataSet.size());
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = dataSetList.get(i);
        }
        if (bl) {
            try {
                dataSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return objectArray;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public void sort() {
        if (this.comparator == null) {
            throw new IllegalStateException("The comparator must be set to sort.");
        }
        Arrays.sort(this.array, this.comparator);
    }
}

