/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access.dataset;

import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ErrorTable;
import com.helpsystems.common.core.util.ValidationHelper;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class AggregateDataSet<T>
implements DataSet {
    private static final Logger logger = Logger.getLogger(AggregateDataSet.class);
    private int aggregateSize;
    private ArrayList<DataSetEntry> entryList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DataSet<T> dataSet) throws DataSetException {
        ValidationHelper.checkForNull("DataSet", dataSet);
        ArrayList<DataSetEntry> arrayList = this.entryList;
        synchronized (arrayList) {
            DataSetEntry dataSetEntry = new DataSetEntry(this.aggregateSize, dataSet);
            this.entryList.add(dataSetEntry);
            this.aggregateSize += dataSetEntry.size();
        }
    }

    @Override
    public void close() {
        DataSet<T>[] dataSetArray = this.getDataSets();
        for (int i = 0; i < dataSetArray.length; ++i) {
            try {
                dataSetArray[i].close();
                continue;
            }
            catch (DataSetException dataSetException) {
                logger.debug((Object)"Unable to close a data set.", (Throwable)dataSetException);
            }
        }
    }

    private DataSetEntry findWhoContains(int n) {
        for (DataSetEntry dataSetEntry : this.entryList) {
            if (dataSetEntry.getStartOffset() > n || n >= dataSetEntry.getEndOffset()) continue;
            return dataSetEntry;
        }
        throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.aggregateSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T[] get(int n, int n2) throws DataSetException, BadDataArrayException {
        if (n < 0 || n >= this.aggregateSize) {
            throw new IndexOutOfBoundsException("Invalid offset: " + n);
        }
        if (n + n2 > this.aggregateSize) {
            throw new IndexOutOfBoundsException("Offset: " + n + " + Length: " + n2 + " > Size: " + this.aggregateSize);
        }
        Object[] objectArray = null;
        ArrayList<DataSetEntry> arrayList = this.entryList;
        synchronized (arrayList) {
            T[] TArray;
            objectArray = new Object[n2];
            for (int i = n; i < n + n2; i += TArray.length) {
                DataSetEntry dataSetEntry = this.findWhoContains(i);
                int n3 = i - dataSetEntry.getStartOffset();
                int n4 = n + n2 - i;
                if (n4 > dataSetEntry.size() - n3) {
                    n4 = dataSetEntry.size() - n3;
                }
                DataSet dataSet = dataSetEntry.getDataSet();
                TArray = null;
                try {
                    TArray = dataSet.get(n3, n4);
                }
                catch (BadDataArrayException badDataArrayException) {
                    ErrorTable errorTable = badDataArrayException.getErrors();
                    errorTable.setIndexOffset(dataSetEntry.getStartOffset());
                    throw badDataArrayException;
                }
                System.arraycopy(TArray, 0, objectArray, i - n, TArray.length);
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet<T>[] getDataSets() {
        DataSet[] dataSetArray = null;
        ArrayList<DataSetEntry> arrayList = this.entryList;
        synchronized (arrayList) {
            dataSetArray = new DataSet[this.entryList.size()];
            Iterator<DataSetEntry> iterator = this.entryList.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                DataSetEntry dataSetEntry = iterator.next();
                dataSetArray[n] = dataSetEntry.getDataSet();
                ++n;
            }
        }
        return dataSetArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(int n, DataSet<T> dataSet) throws DataSetException {
        ValidationHelper.checkForNull("DataSet", dataSet);
        ArrayList<DataSetEntry> arrayList = this.entryList;
        synchronized (arrayList) {
            DataSetEntry dataSetEntry = this.entryList.get(n);
            DataSet dataSet2 = dataSetEntry.getDataSet();
            try {
                dataSet2.close();
            }
            catch (DataSetException dataSetException) {
                logger.debug((Object)"Unable to close a data set.", (Throwable)dataSetException);
            }
            DataSetEntry dataSetEntry2 = new DataSetEntry(dataSetEntry.getStartOffset(), dataSet);
            int n2 = dataSetEntry2.size() - dataSetEntry.size();
            this.entryList.set(n, dataSetEntry2);
            for (int i = n + 1; i < this.entryList.size(); ++i) {
                DataSetEntry dataSetEntry3 = this.entryList.get(i);
                dataSetEntry3.adjust(n2);
            }
            this.aggregateSize += n2;
        }
    }

    @Override
    public int size() {
        return this.aggregateSize;
    }

    class DataSetEntry {
        int aggregateOffset;
        int size;
        DataSet<T> ds;

        DataSetEntry(int n, DataSet<T> dataSet) throws DataSetException {
            this.aggregateOffset = n;
            this.ds = dataSet;
            this.size = dataSet.size();
        }

        void adjust(int n) {
            this.aggregateOffset += n;
        }

        int getStartOffset() {
            return this.aggregateOffset;
        }

        int size() {
            return this.size;
        }

        int getEndOffset() {
            return this.aggregateOffset + this.size;
        }

        DataSet<T> getDataSet() {
            return this.ds;
        }
    }
}

