/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.server.file;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.ValidationHelper;

public class FileBlock
extends CommonVersionedObject {
    private static final long serialVersionUID = -1042732537222485618L;
    private byte[] buf;
    private int length;
    public static final FileBlock EOF = new FileBlock();

    public FileBlock() {
        this.buf = new byte[0];
        this.length = -1;
    }

    public FileBlock(byte[] byArray, int n) {
        ValidationHelper.checkForNull((String)"Buffer", (Object)byArray);
        if (n < 0) {
            throw new IllegalArgumentException("Invalid length " + this.length);
        }
        this.buf = byArray;
        this.length = n;
    }

    public byte[] getBytes() {
        return this.buf;
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!((Object)((Object)this)).getClass().equals(object.getClass())) {
            return false;
        }
        FileBlock fileBlock = (FileBlock)((Object)object);
        return super.equals(object) && Equal.isEqual((Object)this.buf, (Object)fileBlock.buf) && this.length == fileBlock.length;
    }
}

