/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.server.file;

import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.server.file.FileBlock;
import com.helpsystems.common.server.file.FileHandle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BasicFileHandle
extends RandomAccessFile
implements FileHandle {
    private String absolutePath;

    public BasicFileHandle(String string, String string2) throws FileNotFoundException {
        super(BasicFileHandle.checkPath(string), BasicFileHandle.checkMode(string2));
        File file = new File(string);
        this.absolutePath = file.getAbsolutePath();
    }

    private static String checkPath(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Path", (String)string);
        return string;
    }

    private static String checkMode(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Mode", (String)string);
        return string;
    }

    @Override
    public long getLength() throws IOException {
        return this.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileBlock read(int n) throws IOException {
        int n2 = (int)Math.min((long)n, this.length() - this.getFilePointer());
        if (n2 == 0) {
            return FileBlock.EOF;
        }
        int n3 = Thread.currentThread().getPriority();
        try {
            Thread.currentThread().setPriority(1);
            byte[] byArray = new byte[n2];
            int n4 = super.read(byArray);
            if (n4 == -1) {
                FileBlock fileBlock = FileBlock.EOF;
                return fileBlock;
            }
            FileBlock fileBlock = new FileBlock(byArray, n4);
            return fileBlock;
        }
        finally {
            Thread.currentThread().setPriority(n3);
        }
    }

    @Override
    public void write(FileBlock fileBlock) throws IOException {
        super.write(fileBlock.getBytes(), 0, fileBlock.getLength());
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public String getAbsolutePath() {
        return this.absolutePath;
    }
}

