/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.transport.moduleimpl.processor;

import com.helpsystems.common.core.SkybotStackSize;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.transport.moduleimpl.processor.RemoteLingeringObject;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class RemoteEventListener
extends RemoteLingeringObject
implements SimpleEventListener,
Runnable {
    private static final long serialVersionUID = -8947081556640189626L;
    private static final Logger logger = Logger.getLogger(RemoteEventListener.class);
    private HashSet<Class<? extends GenericEvent>> badClassSet;
    private ArrayList<GenericEvent> stuffToSend;
    private boolean keepRunning;

    public RemoteEventListener() {
    }

    public RemoteEventListener(String string, Peer peer, PeerID peerID) {
        super(string, peerID);
        this.setLocalPeer(peer);
        this.badClassSet = new HashSet();
        this.stuffToSend = new ArrayList();
        this.keepRunning = true;
        Thread thread = null;
        long l = SkybotStackSize.getStackSize();
        thread = l != 0L ? new Thread(null, this, "RemoteEventListener", l) : new Thread(this);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        this.keepRunning = false;
        ArrayList<GenericEvent> arrayList = this.stuffToSend;
        synchronized (arrayList) {
            this.stuffToSend.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceEvent(GenericEvent genericEvent) {
        ArrayList<GenericEvent> arrayList = this.stuffToSend;
        synchronized (arrayList) {
            this.stuffToSend.add(genericEvent);
            this.stuffToSend.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.updateName(0, null);
        Throwable throwable = null;
        try {
            while (this.keepRunning) {
                GenericEvent[] genericEventArray = null;
                ArrayList<GenericEvent> arrayList = this.stuffToSend;
                synchronized (arrayList) {
                    if (this.stuffToSend.size() == 0) {
                        this.stuffToSend.wait(5000L);
                    }
                    if (this.stuffToSend.size() > 0) {
                        int n;
                        Class<?> clazz = this.stuffToSend.get(0).getClass();
                        for (n = 1; n < this.stuffToSend.size() && this.stuffToSend.get(n).getClass().equals(clazz); ++n) {
                        }
                        genericEventArray = new GenericEvent[n];
                        for (int i = 0; i < n; ++i) {
                            genericEventArray[i] = this.stuffToSend.get(0);
                            this.stuffToSend.remove(0);
                        }
                    }
                }
                if (this.getLocalPeer().isShutdownStarted()) {
                    return;
                }
                this.sendEventBatch(genericEventArray);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        finally {
            logger.debug((Object)("Ending event notification thread for peer " + this.remotePeerID), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEventBatch(GenericEvent[] genericEventArray) {
        if (genericEventArray == null || genericEventArray.length == 0) {
            return;
        }
        Class<?> clazz = genericEventArray[0].getClass();
        for (int i = 1; i < genericEventArray.length; ++i) {
            if (genericEventArray[i].getClass().equals(clazz)) continue;
            throw new IllegalArgumentException("Mixed classes found " + clazz.getName() + ", and " + genericEventArray[i].getClass().getName());
        }
        if (this.badClassSet.contains(clazz)) {
            return;
        }
        try {
            this.updateName(genericEventArray.length, clazz);
            this.invokeMethod("serviceEvents", new Class[]{GenericEvent[].class}, new Object[]{genericEventArray}, true, false);
        }
        catch (Exception exception) {
            this.handleFailure(exception, clazz);
        }
        finally {
            this.updateName(0, null);
        }
    }

    protected void handleFailure(Throwable throwable, Class<? extends GenericEvent> clazz) {
        Throwable throwable2;
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            if (!(throwable2 instanceof ClassNotFoundException)) continue;
            logger.debug((Object)("The remote peer " + this.remotePeerID.getPeerDescriptor() + " is unable to service the event class " + clazz));
            this.badClassSet.add(clazz);
            return;
        }
        logger.debug((Object)("Unable to invoke \"serviceEvent\" on remote event listener " + this.remotePeerID.getPeerDescriptor() + "\n\t This remote listener will be removed."), throwable2);
        this.getLocalPeer().removeListener((SimpleEventListener)this);
        try {
            this.close();
        }
        catch (Exception exception) {
            logger.debug((Object)("Unable to close resources used by remote listener: " + this), (Throwable)exception);
        }
    }

    public String toString() {
        return this.remotePeerID + ":" + this.objectID;
    }

    private void updateName(int n, Class<? extends GenericEvent> clazz) {
        String[] stringArray;
        String string = null;
        if (clazz != null) {
            stringArray = clazz.getName().replace('.', ' ').split(" ");
            string = stringArray[stringArray.length - 1];
        }
        stringArray = Thread.currentThread();
        if (n == 0) {
            stringArray.setName("Nothing to send to " + this.remotePeerID);
        } else if (n == 1) {
            stringArray.setName("Sending a " + string + " event to " + this.remotePeerID);
        } else {
            stringArray.setName("Sending " + n + " " + string + " events to " + this.remotePeerID);
        }
    }
}

