/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.transport.moduleimpl.processor;

import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.processor.Command;
import com.helpsystems.common.tl.processor.Processable;
import com.helpsystems.common.tl.processor.Processor;
import com.helpsystems.common.tl.processor.impl.PingCommand;
import com.helpsystems.common.tl.processor.impl.PingResponse;
import org.apache.log4j.Logger;

public class PingProcessor
extends Processor {
    private static final Logger logger = Logger.getLogger(PingProcessor.class);

    public String[] listCommands() {
        return new String[]{PingCommand.class.getName(), PingResponse.class.getName()};
    }

    protected void processCommand(HeavyweightPeer heavyweightPeer, Envelope envelope, PingCommand pingCommand) {
        try {
            PingResponse pingResponse = new PingResponse(pingCommand.getSequence());
            pingResponse.setCommand((Command)pingCommand);
            this.sendReplyEnvelope(heavyweightPeer, envelope, (Processable)pingResponse);
        }
        catch (Exception exception) {
            logger.debug((Object)("Error sending a PingResponse to " + envelope.getSource()), (Throwable)exception);
        }
    }

    public void processObject(HeavyweightPeer heavyweightPeer, Envelope envelope, Processable processable) {
        if (processable instanceof PingCommand) {
            this.processCommand(heavyweightPeer, envelope, (PingCommand)processable);
            return;
        }
        if (processable instanceof PingResponse) {
            return;
        }
        throw new RuntimeException("This processor cannot handle an object of type " + processable.getClass().getName());
    }
}

