/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.transport.moduleimpl.processor;

import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.module.EnvelopeProcessingException;
import com.helpsystems.common.tl.processor.Processable;
import com.helpsystems.common.tl.processor.Processor;
import com.helpsystems.transport.moduleimpl.processor.FloodCommand;
import com.helpsystems.transport.moduleimpl.processor.FloodResponse;
import org.apache.log4j.Logger;

public class FloodProcessor
extends Processor {
    private static final Logger logger = Logger.getLogger(FloodProcessor.class);
    private long lastSequence = -1L;

    public String[] listCommands() {
        return new String[]{FloodCommand.class.getName(), FloodResponse.class.getName()};
    }

    protected void processCommand(HeavyweightPeer heavyweightPeer, Envelope envelope, FloodCommand floodCommand) {
        long l = floodCommand.getSequence();
        long l2 = floodCommand.getWaitTime() * 1000L;
        logger.info((Object)("Flood sequence: " + l + " looping " + l2));
        if (l == 0L) {
            this.lastSequence = 0L;
        } else if (this.lastSequence > l) {
            logger.error((Object)"!!! *** !!! Flood out of sequence !!! *** !!!");
        }
        double d = 999999.0;
        if (l2 > 0L) {
            int n = 0;
            while ((long)n < l2) {
                d = Math.sqrt(n + 1);
                d += 0.0;
                ++n;
            }
        }
        try {
            FloodResponse floodResponse = new FloodResponse(l);
            floodResponse.setCommand(floodCommand);
            this.sendReplyEnvelope(heavyweightPeer, envelope, (Processable)floodResponse);
        }
        catch (Exception exception) {
            logger.debug((Object)("Error sending a FloodResponse to " + envelope.getSource()), (Throwable)exception);
        }
    }

    public void processObject(HeavyweightPeer heavyweightPeer, Envelope envelope, Processable processable) throws Exception {
        if (processable instanceof FloodCommand) {
            this.processCommand(heavyweightPeer, envelope, (FloodCommand)processable);
            return;
        }
        if (processable instanceof FloodResponse) {
            return;
        }
        throw new EnvelopeProcessingException("This processor cannot handle an object of type " + processable.getClass().getName());
    }
}

