/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.transport.moduleimpl.processor;

import com.helpsystems.common.tl.Envelope;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.module.EnvelopeProcessingException;
import com.helpsystems.common.tl.processor.Command;
import com.helpsystems.common.tl.processor.Processable;
import com.helpsystems.common.tl.processor.Processor;
import com.helpsystems.common.tl.processor.impl.DownloadModuleJarCommand;
import com.helpsystems.common.tl.processor.impl.DownloadModuleJarResponse;
import java.io.FileOutputStream;
import org.apache.log4j.Logger;

public class DownloadModuleJarProcessor
extends Processor {
    private static final Logger logger = Logger.getLogger(DownloadModuleJarProcessor.class);

    public String[] listCommands() {
        return new String[]{DownloadModuleJarCommand.class.getName(), DownloadModuleJarResponse.class.getName()};
    }

    protected void processCommand(HeavyweightPeer heavyweightPeer, Envelope envelope, DownloadModuleJarCommand downloadModuleJarCommand) {
        DownloadModuleJarResponse downloadModuleJarResponse = null;
        String string = downloadModuleJarCommand.getFilename();
        byte[] byArray = downloadModuleJarCommand.getData();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray, 0, byArray.length);
            fileOutputStream.close();
            heavyweightPeer.jarFileUpdated(string);
            downloadModuleJarResponse = new DownloadModuleJarResponse(true);
        }
        catch (Exception exception) {
            downloadModuleJarResponse = new DownloadModuleJarResponse(false);
            downloadModuleJarResponse.setMessage(exception.getClass().getName() + ": " + exception.getMessage());
            logger.debug((Object)("Error starting up new module " + string), (Throwable)exception);
        }
        if (downloadModuleJarResponse != null) {
            downloadModuleJarResponse.setSource(heavyweightPeer.getRemotePeerID());
            downloadModuleJarResponse.setCommand((Command)downloadModuleJarCommand);
            try {
                this.sendReplyEnvelope(heavyweightPeer, envelope, (Processable)downloadModuleJarResponse);
            }
            catch (Exception exception) {
                logger.debug((Object)("Error sending a Response to " + envelope.getSource()));
            }
        }
    }

    public void processObject(HeavyweightPeer heavyweightPeer, Envelope envelope, Processable processable) throws Exception {
        if (processable instanceof DownloadModuleJarCommand) {
            this.processCommand(heavyweightPeer, envelope, (DownloadModuleJarCommand)processable);
            return;
        }
        if (processable instanceof DownloadModuleJarResponse) {
            this.processResponse(heavyweightPeer, envelope, (DownloadModuleJarResponse)processable);
            return;
        }
        throw new EnvelopeProcessingException("This processor cannot handle an object of type " + processable.getClass().getName());
    }

    protected void processResponse(HeavyweightPeer heavyweightPeer, Envelope envelope, DownloadModuleJarResponse downloadModuleJarResponse) {
        logger.trace((Object)"This processor doesn't care about DownloadModuleJarResponse");
    }
}

