/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.transport.moduleimpl.dm;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.access.TLManagerFactory;
import com.helpsystems.common.tl.dm.RemoteEventAM;
import com.helpsystems.common.tl.event.RemotePeerEvent;
import com.helpsystems.transport.moduleimpl.processor.BatchEventHandler;
import com.helpsystems.transport.moduleimpl.processor.RemoteEventListener;

public class RemoteEventAMImpl
extends AbstractManager
implements RemoteEventAM {
    private HeavyweightPeer localPeer;

    public RemoteEventAMImpl(HeavyweightPeer heavyweightPeer) {
        ValidationHelper.checkForNull((String)"Local peer", (Object)heavyweightPeer);
        this.localPeer = heavyweightPeer;
        this.setName("PEER.RemoteEventAM");
    }

    public void addListenerToPeer(PeerID peerID, SimpleEventListener simpleEventListener) throws ActionFailedException {
        if (peerID == null || peerID.equals((Object)this.localPeer.getRemotePeerID())) {
            this.localPeer.addListener(simpleEventListener);
            return;
        }
        RemoteEventAM remoteEventAM = (RemoteEventAM)TLManagerFactory.createProxy(RemoteEventAM.class, (Peer)this.localPeer, (PeerID)peerID, (String)"PEER.RemoteEventAM");
        try {
            remoteEventAM.getName();
        }
        catch (Exception exception) {
            throw new ActionFailedException("The peer " + peerID + " is not available for remote event notification.", (Throwable)exception);
        }
        String string = this.localPeer.getRemoteObjectRegistry().bindObject((Object)new BatchEventHandler(simpleEventListener), -1, peerID);
        remoteEventAM.registerRemoteListener(string, this.localPeer.getRemotePeerID());
    }

    public void registerRemoteListener(String string, PeerID peerID) {
        ValidationHelper.checkForNull((String)"Object ID", (Object)string);
        ValidationHelper.checkForNull((String)"Peer ID", (Object)peerID);
        RemoteEventListener remoteEventListener = new RemoteEventListener(string, (Peer)this.localPeer, peerID);
        this.localPeer.addListener((SimpleEventListener)remoteEventListener);
    }

    public void fireEvent(String string, RemotePeerEvent remotePeerEvent) {
        ValidationHelper.checkForNull((String)"Remote Object ID", (Object)string);
        ValidationHelper.checkForNull((String)"Event", (Object)remotePeerEvent);
        Object object = this.localPeer.getRemoteObjectRegistry().get(string);
        if (object == null || !(object instanceof SimpleEventListener)) {
            return;
        }
        SimpleEventListener simpleEventListener = (SimpleEventListener)object;
        simpleEventListener.serviceEvent((GenericEvent)remotePeerEvent);
    }
}

