/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.transport.moduleimpl.dm;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.RoutableBasicIdentifier;
import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.network.INetworkHostInfoManager;
import com.helpsystems.common.core.network.ProductIID;
import com.helpsystems.common.core.network.ProductProxy;
import com.helpsystems.common.core.network.SystemIID;
import com.helpsystems.common.core.network.SystemProxy;
import com.helpsystems.common.core.service.Service;
import com.helpsystems.common.core.service.ServiceDescriptor;
import com.helpsystems.common.core.util.TargetVersionInfo;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.ObjectPair;
import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.common.tl.HeavyweightPeer;
import com.helpsystems.common.tl.HeavyweightPeerConfig;
import com.helpsystems.common.tl.Peer;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.common.tl.PeerStats;
import com.helpsystems.common.tl.access.TLManagerFactory;
import com.helpsystems.common.tl.busobj.DataManagerEntry;
import com.helpsystems.common.tl.dm.IPeerInfoManager;
import com.helpsystems.common.tl.event.PeerLoggingLevelUpdatedEvent;
import com.helpsystems.common.tl.ex.NotConnectedException;
import com.helpsystems.common.tl.ex.NotUniqueException;
import com.helpsystems.common.tl.ex.RemoteManagerNotFoundException;
import com.helpsystems.common.tl.module.GenericJarModule;
import com.helpsystems.common.tl.module.Module;
import com.helpsystems.common.tl.module.ModuleInfo;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class PeerInfoManager
extends AbstractManager
implements IPeerInfoManager {
    private static final Logger logger = Logger.getLogger(PeerInfoManager.class);
    private HeavyweightPeer peer;

    public PeerInfoManager(HeavyweightPeer heavyweightPeer) {
        this.peer = heavyweightPeer;
        this.setName("PEER.PeerInfoManager");
    }

    public PeerID findPeer(PeerDescriptor peerDescriptor, PeerID[] peerIDArray) throws NotConnectedException, NotUniqueException {
        return this.peer.findPeer(peerDescriptor, peerIDArray);
    }

    public PeerStats[] getAllPeerStats() {
        return this.peer.getAllStats();
    }

    public String getPeerBuildInfo() {
        return "101";
    }

    public String getPeerConfig() {
        try {
            HeavyweightPeerConfig heavyweightPeerConfig = this.peer.getConfig();
            String string = XMLUtil.documentToString((Document)XMLReflector.writeObject((XMLSerializable)heavyweightPeerConfig));
            return string;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to convert the Config object to a text representation.", exception);
        }
    }

    public int getLoggingLevel() {
        return Logger.getRootLogger().getLevel().toInt();
    }

    public PeerID[] getPeersFromRoutingTable() {
        return this.peer.getPeersFromRoutingTable();
    }

    public Properties getSystemProperties() {
        return System.getProperties();
    }

    public Map<String, String> getSystemEnvironment() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.putAll(System.getenv());
        return hashMap;
    }

    public Date getWhenStarted() {
        return this.peer.getWhenStarted();
    }

    public DataManagerEntry[] listManagers() throws ResourceUnavailableException {
        Collection collection = ManagerRegistry.getManagers();
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList, new Comparator<IAbstractManager>(){

            @Override
            public int compare(IAbstractManager iAbstractManager, IAbstractManager iAbstractManager2) {
                String string = iAbstractManager.getName();
                String string2 = iAbstractManager2.getName();
                return string.compareTo(string2);
            }
        });
        DataManagerEntry[] dataManagerEntryArray = new DataManagerEntry[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            IAbstractManager iAbstractManager = (IAbstractManager)iterator.next();
            dataManagerEntryArray[n] = new DataManagerEntry(iAbstractManager);
            ++n;
        }
        return dataManagerEntryArray;
    }

    public Object[][] listRunningModules() {
        Module[] moduleArray = this.peer.listModules();
        Object[][] objectArray = new Object[moduleArray.length][2];
        for (int i = 0; i < objectArray.length; ++i) {
            GenericJarModule genericJarModule;
            Module module = moduleArray[i];
            moduleArray[i] = null;
            objectArray[i][0] = module.getDescriptor();
            if (module instanceof GenericJarModule) {
                genericJarModule = (GenericJarModule)module;
                objectArray[i][1] = genericJarModule.getInfo();
                continue;
            }
            genericJarModule = module.getDescriptor();
            objectArray[i][1] = new ModuleInfo(genericJarModule.getProductName(), new File("NA"), genericJarModule.getSpecificVersion());
        }
        return objectArray;
    }

    public ServiceDescriptor[] listRunningServices() {
        ServiceDescriptor[] serviceDescriptorArray = this.peer.listServices();
        ArrayList<ServiceDescriptor> arrayList = new ArrayList<ServiceDescriptor>();
        for (int i = 0; i < serviceDescriptorArray.length; ++i) {
            Service service = this.peer.getService(serviceDescriptorArray[i].getName());
            if (service == null || service.getStatus() != 1) continue;
            arrayList.add(serviceDescriptorArray[i]);
        }
        ServiceDescriptor[] serviceDescriptorArray2 = new ServiceDescriptor[arrayList.size()];
        arrayList.toArray(serviceDescriptorArray2);
        return serviceDescriptorArray2;
    }

    public PeerID[] searchRoutingTableFor(PeerDescriptor peerDescriptor) {
        return this.peer.searchRoutingTableFor(peerDescriptor);
    }

    public PeerID[] searchRoutingTableFor(String string, Serializable serializable) {
        return this.peer.searchRoutingTableFor(string, serializable);
    }

    public void setLoggingLevel(int n) throws IOException {
        HeavyweightPeerConfig heavyweightPeerConfig;
        Level level = Level.toLevel((int)n);
        Logger.getRootLogger().setLevel(level);
        logger.log(level, (Object)("Logging level has been changed to " + level.toString()));
        if (this.peer != null) {
            this.peer.addEvent((GenericEvent)new PeerLoggingLevelUpdatedEvent(n));
        }
        if ((heavyweightPeerConfig = this.peer.getConfig()) == null) {
            return;
        }
        ObjectPair[] objectPairArray = heavyweightPeerConfig.getLog4jSettings();
        ObjectPair objectPair = null;
        for (int i = 0; i < objectPairArray.length; ++i) {
            String string = (String)objectPairArray[i].getKey();
            if (!string.equalsIgnoreCase("log4j.rootLogger")) continue;
            objectPair = objectPairArray[i];
            break;
        }
        if (objectPair == null) {
            objectPair = new ObjectPair((Object)"log4j.rootLogger", (Object)level.toString());
        } else {
            String string = (String)objectPair.getValue();
            int n2 = string.indexOf(",");
            if (n2 < 0) {
                objectPair.setValue((Object)level.toString());
            } else {
                string = level.toString() + string.substring(n2);
                objectPair.setValue((Object)string);
            }
        }
        heavyweightPeerConfig.removeLog4jSetting((String)objectPair.getKey());
        heavyweightPeerConfig.addLog4jSetting(objectPair);
        if (this.peer.getConfigPath() != null) {
            this.peer.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testSocket(String string, int n) {
        Socket socket = null;
        try {
            socket = new Socket(string, n);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
    }

    public TargetVersionInfo getVersionInfo() {
        return this.peer.getVersionInfo();
    }

    public PeerID resolveIdentifier(BasicIdentifier basicIdentifier) {
        ValidationHelper.checkForNull((String)"Identifier", (Object)basicIdentifier);
        if (basicIdentifier instanceof RoutableBasicIdentifier) {
            return this.resolvePeer((RoutableBasicIdentifier)basicIdentifier);
        }
        if (basicIdentifier instanceof ProductIID) {
            return this.resolveProduct((ProductIID)basicIdentifier);
        }
        if (basicIdentifier instanceof SystemIID) {
            return this.resolveSystem((SystemIID)basicIdentifier, null);
        }
        throw new IllegalArgumentException("Unable to resolve identifier type " + basicIdentifier.getClass().getName());
    }

    private PeerID resolvePeer(RoutableBasicIdentifier routableBasicIdentifier) {
        PeerID[] peerIDArray = this.peer.searchRoutingTableFor(routableBasicIdentifier.getHardwareHash(), routableBasicIdentifier.getInstanceIdentifier());
        if (peerIDArray.length > 0) {
            return peerIDArray[0];
        }
        peerIDArray = this.searchGatewaysFor(routableBasicIdentifier.getHardwareHash(), routableBasicIdentifier.getInstanceIdentifier(), (BasicIdentifier)routableBasicIdentifier);
        if (peerIDArray.length > 0) {
            return peerIDArray[0];
        }
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        throw new RemoteManagerNotFoundException(peerDescriptor, "For Peer " + routableBasicIdentifier, 0, null);
    }

    private PeerID resolveProduct(ProductIID productIID) {
        INetworkHostInfoManager iNetworkHostInfoManager = (INetworkHostInfoManager)ManagerRegistry.getManagerStartsWith((String)"COMMON.NetworkHostInfoManager");
        ProductProxy productProxy = null;
        try {
            productProxy = iNetworkHostInfoManager.get(productIID);
        }
        catch (Exception exception) {
            throw new RemoteManagerNotFoundException(this.peer.getRemotePeerID().getPeerDescriptor(), productIID.toString(), 0, (Throwable)exception);
        }
        if (productProxy == null) {
            throw new RemoteManagerNotFoundException(this.peer.getRemotePeerID().getPeerDescriptor(), productIID.toString(), 0, null);
        }
        if (productProxy.getNodeProductIID() != 0) {
            try {
                productProxy = iNetworkHostInfoManager.get(new ProductIID(productProxy.getNodeProductIID()));
            }
            catch (Exception exception) {
                throw new RemoteManagerNotFoundException(this.peer.getRemotePeerID().getPeerDescriptor(), "For Node " + productIID.toString(), 0, (Throwable)exception);
            }
            if (productProxy == null) {
                throw new RemoteManagerNotFoundException(this.peer.getRemotePeerID().getPeerDescriptor(), "For Node " + productIID.toString(), 0, null);
            }
        }
        return this.resolveSystem(new SystemIID(productProxy.getSystemIID()), (Serializable)((Object)productProxy.getLocation()));
    }

    private PeerID resolveSystem(SystemIID systemIID, Serializable serializable) {
        INetworkHostInfoManager iNetworkHostInfoManager = (INetworkHostInfoManager)ManagerRegistry.getManagerStartsWith((String)"COMMON.NetworkHostInfoManager");
        SystemProxy systemProxy = null;
        logger.trace((Object)("Resolving System " + systemIID));
        try {
            systemProxy = iNetworkHostInfoManager.get(systemIID);
        }
        catch (Exception exception) {
            throw new RemoteManagerNotFoundException(this.peer.getRemotePeerID().getPeerDescriptor(), systemIID.toString(), 0, (Throwable)exception);
        }
        if (systemProxy == null) {
            throw new RemoteManagerNotFoundException(this.peer.getRemotePeerID().getPeerDescriptor(), systemIID.toString(), 0, null);
        }
        String string = systemProxy.getHardwareKey();
        PeerID[] peerIDArray = this.peer.searchRoutingTableFor(string, serializable);
        logger.trace((Object)("Resolving System for hardware key " + string));
        if (peerIDArray.length == 0 && (peerIDArray = this.searchGatewaysFor(string, serializable, (BasicIdentifier)systemIID)).length == 0) {
            PeerDescriptor peerDescriptor = new PeerDescriptor();
            peerDescriptor.addAddress(systemProxy.getAddress());
            throw new RemoteManagerNotFoundException(peerDescriptor, "For System " + systemIID.toString(), 0, null);
        }
        if (peerIDArray.length == 1) {
            return peerIDArray[0];
        }
        PeerID peerID = null;
        for (int i = 0; i < peerIDArray.length; ++i) {
            PeerDescriptor peerDescriptor = peerIDArray[i].getPeerDescriptor();
            if (peerDescriptor.getType() == 1) {
                return peerIDArray[i];
            }
            if (peerDescriptor.getType() != 2) continue;
            peerID = peerIDArray[i];
        }
        if (peerID != null) {
            return peerID;
        }
        return peerIDArray[0];
    }

    private PeerID[] searchGatewaysFor(String string, Serializable serializable, BasicIdentifier basicIdentifier) {
        HashSet<PeerID> hashSet = new HashSet<PeerID>();
        PeerID peerID = this.peer.getRemotePeerID();
        PeerID[] peerIDArray = this.peer.getGatewaysFromRoutingTable();
        IPeerInfoManager iPeerInfoManager = null;
        for (int i = 0; i < peerIDArray.length; ++i) {
            PeerID peerID2 = peerIDArray[i];
            if (peerID2.equals((Object)peerID)) continue;
            try {
                iPeerInfoManager = (IPeerInfoManager)TLManagerFactory.createProxy(IPeerInfoManager.class, (Peer)this.peer, (PeerID)peerID2, (String)"PEER.PeerInfoManager", (int)-1);
                PeerID[] peerIDArray2 = iPeerInfoManager.searchRoutingTableFor(string, serializable);
                for (int j = 0; j < peerIDArray2.length; ++j) {
                    hashSet.add(peerIDArray2[j]);
                }
                continue;
            }
            catch (Exception exception) {
                logger.debug((Object)("Unable to ask Host " + peerIDArray[i] + " for information about " + basicIdentifier), (Throwable)exception);
            }
        }
        PeerID[] peerIDArray3 = new PeerID[hashSet.size()];
        hashSet.toArray(peerIDArray3);
        return peerIDArray3;
    }
}

