/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.xml;

import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.core.xml.XMLSerializable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public abstract class XMLUtil {
    public static Object loadObjectFromFile(String string) throws IOException {
        Object object = null;
        File file = new File(string);
        if (file.exists()) {
            try {
                Document document = XMLUtil.loadXML(file.getAbsolutePath());
                object = XMLReflector.readObject(document);
            }
            catch (Exception exception) {
                IOException iOException = new IOException("Error loading the file " + file.getAbsolutePath());
                iOException.initCause(exception);
                throw iOException;
            }
        } else {
            throw new IOException("The file " + string + " does not exist.");
        }
        if (object == null) {
            throw new IOException("Unable to load the object from the file.");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadXML(String string) throws IOException, ParserConfigurationException, SAXException {
        if (string == null) {
            throw new NullPointerException("The filename passed in is null.");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException("The file " + string + " does not exist, or couild not be opened.");
        }
        if (file.isDirectory()) {
            throw new IOException("The 'file' " + string + " is a directory.");
        }
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        FileInputStream fileInputStream = null;
        try {
            Document document;
            fileInputStream = new FileInputStream(file);
            Document document2 = document = documentBuilder.parse(fileInputStream);
            return document2;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Document loadXMLAsResource(String string, ClassLoader classLoader) throws IOException, ParserConfigurationException, SAXException {
        ClassLoader classLoader2 = classLoader;
        if (string == null) {
            throw new NullPointerException("The resource name passed in is null.");
        }
        if (classLoader2 == null) {
            classLoader2 = ClassLoader.getSystemClassLoader();
        }
        if (classLoader2 == null) {
            throw new NullPointerException("Unable to get a reference to the system classloader.");
        }
        InputStream inputStream = classLoader2.getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException("Could not find the resource " + string);
        }
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        inputStream.close();
        return document;
    }

    public static void writeXML(Document document, String string) throws TransformerException, IOException {
        if (document == null) {
            throw new NullPointerException("The XML document passed in is null.");
        }
        if (string == null) {
            throw new NullPointerException("The filename passed in is null.");
        }
        File file = new File(string);
        if (file.isDirectory()) {
            throw new IOException("The 'file' " + string + " doesn't indicate the actual name of the file to use.");
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        StreamResult streamResult = new StreamResult(file.toURI().getPath());
        transformer.transform(new DOMSource(document), streamResult);
    }

    public static byte[] documentToBytes(Document document) throws TransformerException {
        if (document == null) {
            throw new NullPointerException("The XML document passed in is null.");
        }
        return XMLUtil.elementToBytes(document.getDocumentElement());
    }

    public static byte[] elementToBytes(Element element) throws TransformerException {
        if (element == null) {
            throw new NullPointerException("The XML Element passed in is null.");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(new DOMSource(element), new StreamResult(byteArrayOutputStream));
        return byteArrayOutputStream.toByteArray();
    }

    public static String documentToString(Document document) throws TransformerException {
        String string = null;
        try {
            string = new String(XMLUtil.documentToBytes(document), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unable to convert UTF-8 byte[] to String", unsupportedEncodingException);
        }
        return string;
    }

    public static String elementToString(Element element) throws TransformerException {
        String string = null;
        try {
            string = new String(XMLUtil.elementToBytes(element), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unable to convert UTF-8 byte[] to String", unsupportedEncodingException);
        }
        return string;
    }

    public static Document bytesToDocument(byte[] byArray) throws IOException, ParserConfigurationException, SAXException {
        if (byArray == null) {
            throw new NullPointerException("The array of data passed in was null.");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return documentBuilder.parse(byteArrayInputStream);
    }

    public static Document stringToDocument(String string) throws IOException, ParserConfigurationException, SAXException {
        if (string == null) {
            throw new NullPointerException("The string of data passed in was null.");
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unable to convert String to a UTF-8 byte array", unsupportedEncodingException);
        }
        return XMLUtil.bytesToDocument(byArray);
    }

    public static Exception[] writeObjectToFile(XMLSerializable xMLSerializable, String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("The configuration path is null.");
        }
        if (xMLSerializable == null) {
            throw new NullPointerException("The object passed in is null.");
        }
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        try {
            XMLUtil.writeXML(XMLReflector.writeObject(xMLSerializable, arrayList), string);
        }
        catch (TransformerException transformerException) {
            IOException iOException = new IOException("Unable to convert the object into XML");
            iOException.initCause(transformerException);
            throw iOException;
        }
        Exception[] exceptionArray = new Exception[arrayList.size()];
        arrayList.toArray(exceptionArray);
        return exceptionArray;
    }

    public static void main(String[] stringArray) throws Exception {
        Comparable<StringBuffer> comparable;
        if (stringArray.length == 0) {
            System.out.println("Give me a string and I'll write it to a file called x.xml.");
            System.out.println("Give me a filename and I'll read/parse the XML.");
        }
        Document document = null;
        boolean bl = false;
        if (stringArray.length == 1 && ((File)(comparable = new File(stringArray[0]))).exists()) {
            bl = true;
            document = XMLUtil.loadXML(((File)comparable).getAbsolutePath());
            String string = XMLUtil.documentToString(document);
            System.out.println(string);
            return;
        }
        if (!bl) {
            comparable = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    ((StringBuffer)comparable).append(' ');
                }
                ((StringBuffer)comparable).append(stringArray[i]);
            }
            String string = ((StringBuffer)comparable).toString();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            document = documentBuilderFactory.newDocumentBuilder().newDocument();
            Element element = document.createElement("test");
            document.appendChild(element);
            Text text = document.createTextNode(string);
            element.appendChild(text);
            XMLUtil.writeXML(document, "x.xml");
            String string2 = XMLUtil.documentToString(document);
            System.out.println(string2);
            return;
        }
        System.out.println("I don't know what to do!");
    }
}

