/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.xml;

import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.common.core.xml.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLReflector {
    private static final Logger logger = Logger.getLogger(XMLReflector.class);

    public static Object copy(XMLSerializable xMLSerializable) {
        if (xMLSerializable == null) {
            throw new NullPointerException("Cannot copy a null object.");
        }
        try {
            Document document = XMLReflector.writeObject(xMLSerializable);
            return XMLReflector.readObject(document, xMLSerializable.getClass().getClassLoader());
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to clone/copy " + xMLSerializable.getClass().getName() + ": " + xMLSerializable, exception);
        }
    }

    public static boolean isIdentical(XMLSerializable xMLSerializable, XMLSerializable xMLSerializable2) {
        if (xMLSerializable == null) {
            return xMLSerializable2 == null;
        }
        if (xMLSerializable2 == null) {
            return false;
        }
        try {
            Document document = XMLReflector.writeObject(xMLSerializable);
            Document document2 = XMLReflector.writeObject(xMLSerializable2);
            String string = XMLUtil.documentToString(document);
            String string2 = XMLUtil.documentToString(document2);
            return string.equals(string2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final Method findAddMethod(Class clazz, String string, Class clazz2) {
        String string2;
        if (string == null) {
            throw new NullPointerException("The method name passed in is null.");
        }
        if (clazz == null) {
            throw new NullPointerException("The Object Class passed in is null.");
        }
        if (clazz2 == null) {
            throw new NullPointerException("The Param Class passed in is null.");
        }
        Method method = null;
        Class[] classArray = new Class[]{clazz2};
        method = XMLReflector.findMethod(clazz, "add" + string, classArray);
        if (method != null) {
            return method;
        }
        if (string.endsWith("s") && (method = XMLReflector.findMethod(clazz, string2 = "add" + string.substring(0, string.length() - 1), classArray)) != null) {
            return method;
        }
        if (string.endsWith("es") && (method = XMLReflector.findMethod(clazz, string2 = "add" + string.substring(0, string.length() - 2), classArray)) != null) {
            return method;
        }
        if (string.endsWith("ies") && (method = XMLReflector.findMethod(clazz, string2 = "add" + string.substring(0, string.length() - 3) + "y", classArray)) != null) {
            return method;
        }
        return null;
    }

    public static final Method findMethod(Class clazz, String string, Class[] classArray) {
        int n;
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (method == null) {
            Method[] methodArray = clazz.getMethods();
            for (n = 0; n < methodArray.length && method == null; ++n) {
                Class<?>[] classArray2;
                String string2 = methodArray[n].getName();
                if (!string2.equals(string) || (classArray2 = methodArray[n].getParameterTypes()).length != classArray.length) continue;
                boolean bl = true;
                for (int i = 0; i < classArray2.length; ++i) {
                    if (classArray2[i].isAssignableFrom(classArray[i])) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                method = methodArray[n];
            }
        }
        if (method == null) {
            boolean bl = false;
            for (n = 0; n < classArray.length; ++n) {
                if (classArray[n].equals(Boolean.class)) {
                    classArray[n] = Boolean.TYPE;
                    bl = true;
                }
                if (classArray[n].equals(Byte.class)) {
                    classArray[n] = Byte.TYPE;
                    bl = true;
                }
                if (classArray[n].equals(Character.class)) {
                    classArray[n] = Character.TYPE;
                    bl = true;
                }
                if (classArray[n].equals(Double.class)) {
                    classArray[n] = Double.TYPE;
                    bl = true;
                }
                if (classArray[n].equals(Float.class)) {
                    classArray[n] = Float.TYPE;
                    bl = true;
                }
                if (classArray[n].equals(Integer.class)) {
                    classArray[n] = Integer.TYPE;
                    bl = true;
                }
                if (classArray[n].equals(Long.class)) {
                    classArray[n] = Long.TYPE;
                    bl = true;
                }
                if (!classArray[n].equals(Short.class)) continue;
                classArray[n] = Short.TYPE;
                bl = true;
            }
            if (bl) {
                try {
                    method = clazz.getMethod(string, classArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return method;
    }

    public static Document writeObject(XMLSerializable xMLSerializable) throws DOMException {
        return XMLReflector.writeObject(xMLSerializable, null);
    }

    public static Document writeObject(XMLSerializable xMLSerializable, List<Throwable> list) throws DOMException {
        if (xMLSerializable == null) {
            throw new NullPointerException("The bean passed in is null.");
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            document = documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new NullPointerException("The DocumentBuilder failed to return a new Document. " + parserConfigurationException.getClass().getName() + ": " + parserConfigurationException.getMessage());
        }
        if (document == null) {
            throw new NullPointerException("The DocumentBuilder returned a null Document. ");
        }
        Comment comment = document.createComment(" Created at " + new Date() + " ");
        document.appendChild(comment);
        Element element = document.createElement("settings");
        document.appendChild(element);
        Element element2 = document.createElement("object");
        element2.setAttribute("class", xMLSerializable.getClass().getName());
        XMLReflector.fillProperties(element2, xMLSerializable, list);
        element.appendChild(element2);
        return document;
    }

    private static void fillPrimitiveArray(Object object, List<Object> list) {
        block10: {
            Class<?> clazz;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    block9: {
                                        Class<?> clazz2 = object.getClass();
                                        if (!clazz2.isArray()) {
                                            throw new IllegalArgumentException("The class " + clazz2.getName() + " is not an array.");
                                        }
                                        clazz = clazz2.getComponentType();
                                        if (!clazz.equals(Boolean.TYPE)) break block9;
                                        boolean[] blArray = (boolean[])object;
                                        for (int i = 0; i < blArray.length; ++i) {
                                            blArray[i] = (Boolean)list.get(i);
                                        }
                                        break block10;
                                    }
                                    if (!clazz.equals(Byte.TYPE)) break block11;
                                    byte[] byArray = (byte[])object;
                                    for (int i = 0; i < byArray.length; ++i) {
                                        byArray[i] = (Byte)list.get(i);
                                    }
                                    break block10;
                                }
                                if (!clazz.equals(Short.TYPE)) break block12;
                                short[] sArray = (short[])object;
                                for (int i = 0; i < sArray.length; ++i) {
                                    sArray[i] = (Short)list.get(i);
                                }
                                break block10;
                            }
                            if (!clazz.equals(Character.TYPE)) break block13;
                            char[] cArray = (char[])object;
                            for (int i = 0; i < cArray.length; ++i) {
                                cArray[i] = ((Character)list.get(i)).charValue();
                            }
                            break block10;
                        }
                        if (!clazz.equals(Integer.TYPE)) break block14;
                        int[] nArray = (int[])object;
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = (Integer)list.get(i);
                        }
                        break block10;
                    }
                    if (!clazz.equals(Long.TYPE)) break block15;
                    long[] lArray = (long[])object;
                    for (int i = 0; i < lArray.length; ++i) {
                        lArray[i] = (Long)list.get(i);
                    }
                    break block10;
                }
                if (!clazz.equals(Float.TYPE)) break block16;
                float[] fArray = (float[])object;
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = ((Float)list.get(i)).floatValue();
                }
                break block10;
            }
            if (!clazz.equals(Double.TYPE)) break block10;
            double[] dArray = (double[])object;
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = (Double)list.get(i);
            }
        }
    }

    private static void fillProperties(Element element, XMLSerializable xMLSerializable, List<Throwable> list) throws DOMException {
        if (element == null) {
            throw new NullPointerException("The node passed in was null.");
        }
        if (xMLSerializable == null) {
            throw new NullPointerException("The bean passed in was null.");
        }
        Document document = element.getOwnerDocument();
        if (document == null) {
            throw new NullPointerException("The Node that was passed in does not have a Document that owns the node.");
        }
        Method[] methodArray = xMLSerializable.getClass().getMethods();
        String[] stringArray = xMLSerializable.doNotInvoke();
        List<String> list2 = null;
        if (stringArray != null) {
            list2 = Arrays.asList(stringArray);
        }
        for (int i = 0; i < methodArray.length; ++i) {
            Object object;
            Object object2;
            String string;
            block16: {
                Method method = methodArray[i];
                if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) continue;
                String string2 = method.getName();
                if (list2 != null && list2.contains(string2)) continue;
                Class<?>[] classArray = method.getParameterTypes();
                string = null;
                object2 = null;
                if (string2.startsWith("get") && string2.length() > 3 && classArray.length == 0) {
                    if (string2.equals("getClass")) continue;
                    if (string2.charAt(3) >= 'A' && string2.charAt(3) <= 'Z') {
                        string = string2.substring(3);
                        try {
                            object2 = method.invoke((Object)xMLSerializable, (Object[])null);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            logger.debug((Object)"", (Throwable)invocationTargetException);
                            string = null;
                            if (list != null) {
                                list.add(invocationTargetException.getCause());
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            logger.debug((Object)"", (Throwable)illegalAccessException);
                            string = null;
                            if (list == null) break block16;
                            list.add(illegalAccessException);
                        }
                    }
                }
            }
            if (string == null || object2 == null) continue;
            Class<?> clazz = object2.getClass();
            Element element2 = document.createElement("property");
            element2.setAttribute("name", string);
            element2.setAttribute("class", clazz.getName());
            if (clazz.isArray()) {
                object = clazz.getComponentType();
                element2.setAttribute("class", ((Class)object).getName());
                element2.setAttribute("type", "array");
                int n = Array.getLength(object2);
                for (int j = 0; j < n; ++j) {
                    Object object3 = Array.get(object2, j);
                    if (object3 == null) continue;
                    Element element3 = XMLReflector.serializeObjectToElement(document, object3, list);
                    element2.appendChild(element3);
                }
            } else if (clazz.isPrimitive() || clazz.getName().startsWith("java.lang.")) {
                element2.setAttribute("value", object2.toString());
            } else {
                object = XMLReflector.serializeObjectToElement(document, object2, list);
                element2.appendChild((Node)object);
            }
            element.appendChild(element2);
        }
    }

    private static Element serializeObjectToElement(Document document, Object object, List<Throwable> list) {
        Class<?> clazz = object.getClass();
        Element element = null;
        if (clazz.isPrimitive() || clazz.getName().startsWith("java.lang.")) {
            element = document.createElement("object");
            element.setAttribute("class", clazz.getName());
            element.setAttribute("value", object.toString());
        } else if (object instanceof XMLSerializable) {
            element = document.createElement("object");
            element.setAttribute("class", clazz.getName());
            XMLReflector.fillProperties(element, (XMLSerializable)object, list);
        } else if (object instanceof Serializable) {
            String string = null;
            try {
                string = XMLReflector.serializeSpecial((Serializable)object);
            }
            catch (IOException iOException) {
                throw new RuntimeException("The object " + object.getClass().getName() + " couldn't be serialized. ", iOException);
            }
            element = document.createElement("sz-object");
            element.setAttribute("class", clazz.getName());
            element.setAttribute("data", string);
        } else {
            throw new RuntimeException("The object " + clazz.getName() + " does not implement" + " XMLSerializable nor Serializable" + " and cannot be saved.");
        }
        return element;
    }

    public static Object readObject(Document document) throws Exception {
        return XMLReflector.readObject(document, null);
    }

    public static Object readObject(Document document, ClassLoader classLoader) throws Exception {
        return XMLReflector.fillObject(document, null, classLoader);
    }

    private static Object fillObject(Document document, Object object, ClassLoader classLoader) throws Exception {
        Node node;
        if (document == null) {
            throw new NullPointerException("The doc passed in was null.");
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            return null;
        }
        String string = element.getNodeName();
        if (!"settings".equals(string)) {
            throw new RuntimeException("The first tag in the Document was " + string + "; expected 'settings'");
        }
        for (node = element.getFirstChild(); node != null && !(node instanceof Element); node = node.getNextSibling()) {
        }
        if (node == null) {
            throw new RuntimeException("Unable to find a \"properties\" tag within the settings.");
        }
        string = node.getNodeName();
        if (!"object".equals(string)) {
            throw new RuntimeException("The second tag in the Document was " + string + "; expected 'object'");
        }
        Object object2 = object;
        if (object2 == null) {
            object2 = XMLReflector.createObject((Element)node, classLoader);
        } else {
            XMLReflector.restoreProperties(object2, (Element)node, classLoader);
        }
        return object2;
    }

    protected static Object createObject(Element element, ClassLoader classLoader) throws Exception {
        if (element == null) {
            throw new NullPointerException("The Element passed in was null.");
        }
        String string = element.getNodeName();
        if (string.equals("object")) {
            return XMLReflector.createRegularObject(element, classLoader);
        }
        if (string.equals("sz-object")) {
            return XMLReflector.createSpecialObject(element);
        }
        throw new IllegalArgumentException("The element tag " + string + " is not recognized.");
    }

    private static Object createRegularObject(Element element, ClassLoader classLoader) throws Exception {
        if (element == null) {
            throw new NullPointerException("The Element passed in was null.");
        }
        if (!element.getNodeName().equals("object")) {
            throw new IllegalArgumentException("The element must be an 'object' tag. The element passed in was a '" + element.getNodeName() + "' tag.");
        }
        String string = element.getAttribute("class");
        if (string == null) {
            throw new NullPointerException("The tag " + element.getNodeName() + " did not specify the" + " 'class' of the object to be restored.");
        }
        String string2 = null;
        if (element.hasAttribute("value")) {
            string2 = element.getAttribute("value");
        }
        Object object = null;
        if (string2 == null) {
            Class clazz = XMLReflector.loadClass(string, classLoader);
            object = clazz.newInstance();
            XMLReflector.restoreProperties(object, element, classLoader);
        } else {
            object = XMLReflector.createSingleObject(string, string2, classLoader);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object createSpecialObject(Element element) throws Exception {
        if (element == null) {
            throw new NullPointerException("The Element passed in was null.");
        }
        if (!element.getNodeName().equals("sz-object")) {
            throw new IllegalArgumentException("The element must be a 'sz-object' tag. The element passed in was a '" + element.getNodeName() + "' tag.");
        }
        String string = null;
        if (element.hasAttribute("data")) {
            string = element.getAttribute("data");
        }
        if (string == null || string.length() == 0) {
            throw new NullPointerException("The 'data' field for a 'sz-object' tag is missing or empty.");
        }
        byte[] byArray = DatatypeConverter.parseBase64Binary((String)string);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        try {
            Object object = objectInputStream.readObject();
            return object;
        }
        finally {
            objectInputStream.close();
            byteArrayInputStream.close();
        }
    }

    protected static void restoreProperties(Object object, Element element, ClassLoader classLoader) throws Exception {
        if (object == null) {
            throw new NullPointerException("The Object passed in was null.");
        }
        if (element == null) {
            throw new NullPointerException("The Element passed in was null.");
        }
        if (!element.getNodeName().equals("object")) {
            throw new IllegalArgumentException("The element must be an 'object' tag. The element passed in was a '" + element.getNodeName() + "' tag.");
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object2;
            Object object3;
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !"property".equals((element2 = (Element)node).getNodeName())) continue;
            Object object4 = null;
            String string = element2.getAttribute("name");
            if (string == null || string.length() == 0) {
                throw new NullPointerException("Encountered a 'property' tag that failed to include a 'name' attribute.");
            }
            String string2 = element2.getAttribute("class");
            if (string2 == null || string2.length() == 0) {
                throw new NullPointerException("Encountered a 'property' tag that failed to include a 'class' attribute.");
            }
            String string3 = null;
            if (element2.hasAttribute("value")) {
                string3 = element2.getAttribute("value");
            }
            String string4 = null;
            if (element2.hasAttribute("type")) {
                string4 = element2.getAttribute("type");
            }
            if (string4 == null) {
                if (string3 != null) {
                    object4 = XMLReflector.createSingleObject(string2, string3, classLoader);
                } else {
                    for (object3 = element2.getFirstChild(); object3 != null && !(object3 instanceof Element); object3 = object3.getNextSibling()) {
                    }
                    object2 = (Element)object3;
                    if (object2 != null) {
                        object4 = XMLReflector.createObject((Element)object2, classLoader);
                    }
                }
                if (object4 == null) continue;
                object3 = XMLReflector.loadClass(string2, classLoader);
                object2 = XMLReflector.findMethod(object.getClass(), "set" + string, new Class[]{object3});
                if (object2 == null) {
                    throw new RuntimeException("The class " + object.getClass().getName() + " does not contain a method set" + string + "(" + object4.getClass().getName() + ")");
                }
                ((Method)object2).invoke(object, object4);
                continue;
            }
            if (string4.equals("array")) {
                Object[] objectArray;
                object3 = XMLReflector.loadClass(string2, classLoader);
                object2 = XMLReflector.findMethod(object.getClass(), "set" + string, new Class[]{XMLReflector.makeArrayClass((Class)object3)});
                boolean bl = false;
                if (object2 == null && (object2 = XMLReflector.findAddMethod(object.getClass(), string, (Class)object3)) != null) {
                    bl = true;
                }
                if (object2 == null) {
                    throw new RuntimeException("The class " + object.getClass().getName() + " does not contain a method to set/add " + string + " for objects " + string2);
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                NodeList nodeList2 = element2.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Object object5;
                    Element element3;
                    objectArray = nodeList2.item(j);
                    if (!(objectArray instanceof Element) || !"object".equals((element3 = (Element)objectArray).getNodeName()) && !"sz-object".equals(element3.getNodeName()) || (object5 = XMLReflector.createObject(element3, classLoader)) == null) continue;
                    if (bl) {
                        ((Method)object2).invoke(object, object5);
                        continue;
                    }
                    arrayList.add(object5);
                }
                if (bl || arrayList.size() <= 0) continue;
                Object[] objectArray2 = Array.newInstance(object3, arrayList.size());
                try {
                    objectArray = objectArray2;
                    arrayList.toArray(objectArray);
                    objectArray2 = objectArray;
                }
                catch (ClassCastException classCastException) {
                    XMLReflector.fillPrimitiveArray(objectArray2, arrayList);
                }
                ((Method)object2).invoke(object, new Object[]{objectArray2});
                continue;
            }
            throw new RuntimeException("A 'property' element has a 'type' attribute set to " + string4 + ". This type is not recognized.");
        }
    }

    protected static Object createSingleObject(Class clazz, String string) throws Exception {
        Class clazz2 = clazz;
        if (clazz2 == null) {
            throw new NullPointerException("The Class passed in is null.");
        }
        Object var3_3 = null;
        if (clazz2.equals(Boolean.TYPE)) {
            clazz2 = Boolean.class;
        }
        if (clazz2.equals(Byte.TYPE)) {
            clazz2 = Byte.class;
        }
        if (clazz2.equals(Character.TYPE)) {
            clazz2 = Character.class;
        }
        if (clazz2.equals(Double.TYPE)) {
            clazz2 = Double.class;
        }
        if (clazz2.equals(Float.TYPE)) {
            clazz2 = Float.class;
        }
        if (clazz2.equals(Integer.TYPE)) {
            clazz2 = Integer.class;
        }
        if (clazz2.equals(Long.TYPE)) {
            clazz2 = Long.class;
        }
        if (clazz2.equals(Short.TYPE)) {
            clazz2 = Short.class;
        }
        if (string == null || string.length() == 0) {
            var3_3 = clazz2.newInstance();
        } else {
            Constructor constructor = null;
            try {
                if (clazz2.equals(Character.class)) {
                    constructor = clazz2.getDeclaredConstructor(Character.TYPE);
                    var3_3 = constructor.newInstance(new Character(string.charAt(0)));
                } else {
                    constructor = clazz2.getDeclaredConstructor(String.class);
                    var3_3 = constructor.newInstance(string);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                String string2 = "Can't reconstruct object " + clazz2.getName() + " with value " + string + " because the class doesn't have a constructor" + " that takes a single String argument.";
                logger.debug((Object)string2, (Throwable)noSuchMethodException);
                throw new RuntimeException(string2);
            }
        }
        return var3_3;
    }

    protected static Object createSingleObject(String string, String string2, ClassLoader classLoader) throws Exception {
        if (string == null) {
            throw new NullPointerException("The classname passed in is null.");
        }
        Class clazz = XMLReflector.loadClass(string, classLoader);
        return XMLReflector.createSingleObject(clazz, string2);
    }

    protected static Class loadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (classLoader != null) {
            try {
                return classLoader.loadClass(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Class.forName(string);
    }

    private static String serializeSpecial(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.close();
        String string = DatatypeConverter.printBase64Binary((byte[])byteArrayOutputStream.toByteArray());
        string = string.replaceAll("[\r\n]", "");
        return string;
    }

    private static Class makeArrayClass(Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            return boolean[].class;
        }
        if (clazz.equals(Byte.TYPE)) {
            return byte[].class;
        }
        if (clazz.equals(Short.TYPE)) {
            return short[].class;
        }
        if (clazz.equals(Character.TYPE)) {
            return char[].class;
        }
        if (clazz.equals(Integer.TYPE)) {
            return int[].class;
        }
        if (clazz.equals(Long.TYPE)) {
            return long[].class;
        }
        if (clazz.equals(Float.TYPE)) {
            return float[].class;
        }
        if (clazz.equals(Double.TYPE)) {
            return double[].class;
        }
        Object[] objectArray = (Object[])Array.newInstance(clazz, 0);
        return objectArray.getClass();
    }
}

