/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.xml;

import com.helpsystems.common.core.xml.XMLTestObject;
import com.helpsystems.common.core.xml.XMLUtil;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestXMLReflector
extends TestCase {
    static String FILENAME = "xmltest.xml";
    static XMLTestObject testObject;

    protected void setUp() throws Exception {
        super.setUp();
        testObject = XMLTestObject.makeAnObject();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testEquality() throws Exception {
        if (!testObject.equals(testObject)) {
            TestXMLReflector.fail((String)"The 'equals' method doesn't work.");
        }
    }

    public void testSaveAndLoadFromFile() throws Exception {
        Exception[] exceptionArray = XMLUtil.writeObjectToFile(testObject, FILENAME);
        XMLTestObject xMLTestObject = (XMLTestObject)XMLUtil.loadObjectFromFile(FILENAME);
        if (!xMLTestObject.equals(testObject)) {
            System.out.println("Original object -------------");
            System.out.println(testObject);
            System.out.println("Restored object -------------");
            System.out.println(xMLTestObject);
            TestXMLReflector.fail((String)"Restored object is not equal.");
        }
        if (exceptionArray.length != 1) {
            TestXMLReflector.fail((String)"The cranky method didn't return a warning.");
        }
        if (!(exceptionArray[0] instanceof RuntimeException)) {
            TestXMLReflector.fail((String)"The cranky warning should have been a RuntimeException");
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TestXMLReflector.suite());
    }

    public static Test suite() {
        return new TestSuite(TestXMLReflector.class);
    }
}

