/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.xml;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.xml.XMLSerializable;
import com.helpsystems.common.core.xml.XMLUtil;
import java.io.File;
import java.io.IOException;

public abstract class AbstractXMLFileManager
extends AbstractManager {
    protected File xmlFile;

    public AbstractXMLFileManager(File file) throws IOException {
        this.xmlFile = file;
    }

    protected synchronized XMLSerializable load() throws ResourceUnavailableException {
        try {
            return (XMLSerializable)XMLUtil.loadObjectFromFile(this.xmlFile.getAbsolutePath());
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to load an object from the file " + this.xmlFile.getAbsolutePath(), exception);
        }
    }

    protected synchronized void save(XMLSerializable xMLSerializable) throws ResourceUnavailableException {
        try {
            XMLUtil.writeObjectToFile(xMLSerializable, this.xmlFile.getAbsolutePath());
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable save the object into the XML file.", exception);
        }
    }
}

