/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.util.ResourceBundleHandler;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.util.List;

public class ValidationHelper {
    private static ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(ValidationHelper.class.getName());

    private ValidationHelper() {
    }

    public static void checkForNull(String string, Object object) {
        ValidationHelper.checkForNull(string, object, null);
    }

    public static void checkForNull(String string, Object object, List<String> list) {
        ValidationHelper.internalCheckForNullAndBlank("fieldName", string, null);
        ValidationHelper.internalCheckForNull(string, object, list);
    }

    public static void checkForBlankIgnoreNull(String string, String string2) {
        ValidationHelper.internalCheckForNullAndBlank("fieldName", string, null);
        ValidationHelper.internalCheckForBlankIgnoreNull(string, string2, null);
    }

    public static void checkForNullAndBlank(String string, String string2) {
        ValidationHelper.checkForNullAndBlank(string, string2, null);
    }

    public static void checkForNullAndBlank(String string, String string2, List<String> list) {
        ValidationHelper.internalCheckForNullAndBlank("fieldName", string, null);
        ValidationHelper.internalCheckForNullAndBlank(string, string2, list);
    }

    public static void validateReqFieldNotZero(String string, int n) {
        ValidationHelper.validateReqFieldNotZero(string, n, null);
    }

    public static void validateReqFieldNotZero(String string, long l) {
        ValidationHelper.internalCheckForNullAndBlank("fieldName", string, null);
        if (l == 0L) {
            String string2 = rbh.getMsg("required", string);
            throw new IllegalStateException(string2);
        }
    }

    public static void validateReqFieldNotZero(String string, int n, List<String> list) {
        ValidationHelper.internalCheckForNullAndBlank("fieldName", string, null);
        if (n == 0) {
            String string2 = rbh.getMsg("required", string);
            if (list == null) {
                throw new IllegalStateException(string2);
            }
            list.add(string2);
        }
    }

    public static void validateReqFieldNotNull(String string, Object object) {
        ValidationHelper.internalCheckForNullAndBlank("fieldName", string, null);
        if (object == null) {
            String string2 = rbh.getMsg("required", string);
            throw new IllegalStateException(string2);
        }
    }

    public static void validateReqFieldForNullAndBlank(String string, String string2) {
        ValidationHelper.internalCheckForNullAndBlank("fieldName", string, null);
        if (string2 == null || string2.trim().length() == 0) {
            String string3 = rbh.getMsg("required", string);
            throw new IllegalStateException(string3);
        }
    }

    public static void validateBounds(String string, long l, long l2, long l3) {
        ValidationHelper.validateBounds(string, l, l2, l3, null);
    }

    public static void validateBounds(String string, long l, long l2, long l3, List<String> list) {
        String string2;
        ValidationHelper.internalCheckForNullAndBlank("fieldName", string, null);
        if (l3 < l) {
            string2 = rbh.getMsg("less_than", string, Long.toString(l));
            if (list == null) {
                throw new IllegalArgumentException(string2);
            }
            list.add(string2);
        }
        if (l3 > l2) {
            string2 = rbh.getMsg("greater_than", string, Long.toString(l2));
            if (list == null) {
                throw new IllegalArgumentException(string2);
            }
            list.add(string2);
        }
    }

    public static void validateBounds(String string, double d, double d2, double d3) {
        ValidationHelper.validateBounds(string, d, d2, d3, null, null);
    }

    public static void validateBounds(String string, double d, double d2, double d3, List<String> list, NumberFormat numberFormat) {
        String string2;
        String string3;
        ValidationHelper.internalCheckForNullAndBlank("fieldName", string, null);
        if (d3 < d) {
            string3 = null;
            string3 = numberFormat == null ? Double.toString(d) : numberFormat.format(string3);
            string2 = rbh.getMsg("less_than", string, string3);
            if (list == null) {
                throw new IllegalArgumentException(string2);
            }
            list.add(string2);
        }
        if (d3 > d2) {
            string3 = null;
            string3 = numberFormat == null ? Double.toString(d2) : numberFormat.format(string3);
            string2 = rbh.getMsg("greater_than", string, string3);
            if (list == null) {
                throw new IllegalArgumentException(string2);
            }
            list.add(string2);
        }
    }

    public static void validateLength(String string, int n, String string2) {
        ValidationHelper.validateLength(string, n, string2, null);
    }

    public static void validateLength(String string, int n, String string2, List<String> list) {
        ValidationHelper.internalCheckForNullAndBlank("fieldName", string, null);
        if (string2 == null) {
            return;
        }
        ValidationHelper.internalCheckForNull(string, string2, list);
        if (string2.length() > n) {
            String string3 = rbh.getMsg("max_length", string, Integer.toString(n));
            if (list == null) {
                throw new IllegalArgumentException(string3);
            }
            list.add(string3);
        }
    }

    public static void validateLengthUTF8(String string, int n, String string2) {
        ValidationHelper.validateLengthUTF8(string, n, string2, null);
    }

    public static void validateLengthUTF8(String string, int n, String string2, List<String> list) {
        ValidationHelper.internalCheckForNullAndBlank("fieldName", string, null);
        if (string2 == null) {
            return;
        }
        ValidationHelper.internalCheckForNull(string, string2, list);
        byte[] byArray = null;
        try {
            byArray = string2.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unable to perform utf-8 conversion.", unsupportedEncodingException);
        }
        if (byArray.length > n) {
            String string3 = rbh.getMsg("max_length", string, Integer.toString(n));
            if (list == null) {
                throw new IllegalArgumentException(string3);
            }
            list.add(string3);
        }
    }

    private static void internalCheckForBlankIgnoreNull(String string, String string2, List<String> list) {
        if (string2 != null && string2.trim().length() == 0) {
            String string3 = rbh.getMsg("required", string);
            if (list == null) {
                throw new IllegalArgumentException(string3);
            }
            list.add(string3);
        }
    }

    private static void internalCheckForNull(String string, Object object, List<String> list) {
        if (object == null) {
            String string2 = string + " cannot be null.";
            if (list == null) {
                throw new NullPointerException(string2);
            }
            list.add(string2);
        }
    }

    private static void internalCheckForNullAndBlank(String string, String string2, List<String> list) {
        ValidationHelper.internalCheckForNull(string, string2, list);
        ValidationHelper.internalCheckForBlankIgnoreNull(string, string2, list);
    }
}

