/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.TargetVersionInfo;
import com.helpsystems.common.core.util.ValidationHelper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;

public class ThreadSession {
    private static final Map<Thread, ThreadSession> map = new HashMap<Thread, ThreadSession>();
    private Locale locale = Locale.getDefault();
    private TargetVersionInfo versionInfo = new TargetVersionInfo();

    private ThreadSession() {
        CommonVersionedObject.staticFillInVersion(this.versionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endSession() {
        Thread thread = Thread.currentThread();
        Map<Thread, ThreadSession> map = ThreadSession.map;
        synchronized (map) {
            ThreadSession.map.remove(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadSession getSession() {
        Thread thread = Thread.currentThread();
        Map<Thread, ThreadSession> map = ThreadSession.map;
        synchronized (map) {
            return ThreadSession.map.get(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadSession getOrCreateSession() {
        Thread thread = Thread.currentThread();
        ThreadSession threadSession = null;
        Map<Thread, ThreadSession> map = ThreadSession.map;
        synchronized (map) {
            ThreadSession.purge();
            threadSession = ThreadSession.map.get(thread);
            if (threadSession == null) {
                threadSession = new ThreadSession();
                ThreadSession.map.put(thread, threadSession);
            }
        }
        return threadSession;
    }

    private static void purge() {
        Iterator<Thread> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Thread thread = iterator.next();
            if (thread.isAlive()) continue;
            iterator.remove();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TargetVersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public void setLocale(Locale locale) {
        ValidationHelper.checkForNull("Locale", locale);
        this.locale = locale;
    }

    public void setVersionInfo(TargetVersionInfo targetVersionInfo) {
        ValidationHelper.checkForNull("Version Info", targetVersionInfo);
        this.versionInfo = targetVersionInfo;
    }
}

