/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.util.TextFolder;
import junit.framework.TestCase;

public class TextFolderTest
extends TestCase {
    private TextFolder tf;

    protected void setUp() throws Exception {
        super.setUp();
        String string = "one-a one-b two-a too-big-for-line-two line-five";
        this.tf = new TextFolder(string, 12);
    }

    protected void tearDown() throws Exception {
        this.tf = null;
        super.tearDown();
    }

    public void testRemoveIsUnsupported() {
        try {
            this.tf.remove();
            TextFolderTest.fail((String)"remove() should not have been supported for this class");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testHasNext() {
        TextFolderTest.assertTrue((boolean)this.tf.hasNext());
        while (this.tf.hasNext()) {
            this.tf.nextString();
        }
        TextFolderTest.assertFalse((boolean)this.tf.hasNext());
    }

    public void testNext() {
        Object object = this.tf.next();
        TextFolderTest.assertTrue((boolean)(object instanceof String));
        TextFolderTest.assertEquals((String)"one-a one-b", (String)((String)object));
    }

    public void testNextString() {
        TextFolderTest.assertEquals((String)"one-a one-b", (String)this.tf.nextString());
        TextFolderTest.assertEquals((String)"two-a", (String)this.tf.nextString());
        TextFolderTest.assertEquals((String)"too-big-for-", (String)this.tf.nextString());
        TextFolderTest.assertEquals((String)"line-two", (String)this.tf.nextString());
        TextFolderTest.assertEquals((String)"line-five", (String)this.tf.nextString());
    }

    public void testGetAll() {
        String string = "one-a one-b!two-a!too-big-for-!line-two!line-five";
        String string2 = this.tf.getAll("!");
        TextFolderTest.assertEquals((String)string, (String)string2);
        string = "one-a one-b two-atoo-big-for-line-twoline-five";
        string2 = this.tf.getAll(null);
    }

    public void testWholeChunker() {
        String string = "12345 123456 1234567";
        TextFolder textFolder = new TextFolder(string, 6);
        TextFolderTest.assertEquals((String)"12345", (String)textFolder.nextString());
        TextFolderTest.assertEquals((String)"123456", (String)textFolder.nextString());
        TextFolderTest.assertEquals((String)"123456", (String)textFolder.nextString());
        TextFolderTest.assertEquals((String)"7", (String)textFolder.nextString());
    }
}

