/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.util.RunnableThrottleObject;
import com.helpsystems.common.core.util.RunnableThrottleRunner;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;

public class RunnableThrottle
implements Runnable {
    private static final Logger logger = Logger.getLogger(RunnableThrottle.class);
    private volatile boolean running = false;
    private String throttleThreadName = null;
    private String throttleID = null;
    private RunnableThrottleRunner runner = null;
    private int maxActiveCount = 15;
    private Semaphore semaphore = null;
    boolean debug = false;
    private final LinkedBlockingQueue<RunnableThrottleObject> queue = new LinkedBlockingQueue();

    public RunnableThrottle(int n, String string, String string2, RunnableThrottleRunner runnableThrottleRunner) {
        this.maxActiveCount = n;
        this.throttleThreadName = string;
        this.throttleID = string2;
        this.runner = runnableThrottleRunner;
        String string3 = "skybot.thread." + this.throttleID;
        String string4 = string3 + ".debug";
        logger.debug((Object)("Loading RunnableThrottle debug override: " + string4));
        String string5 = System.getProperty(string4);
        if (string5 != null && string5.trim().length() > 0) {
            this.debug = "true".equalsIgnoreCase(string5.trim());
        }
        String string6 = string3 + ".max";
        logger.debug((Object)("Loading RunnableThrottle maximum active override: " + string6));
        String string7 = System.getProperty(string6);
        if (string7 != null && string7.trim().length() > 0) {
            try {
                int n2 = Integer.parseInt(string7.trim());
                if (n2 > 0) {
                    logger.info((Object)("Overriding RunnableThrottle maximum active override (" + string6 + "): " + n2));
                    n = n2;
                } else {
                    logger.warn((Object)("Invalid value for RunnableThrottle maximum active override (" + string6 + "): " + n2));
                }
            }
            catch (Exception exception) {
                logger.warn((Object)("Invalid value for RunnableThrottle maximum active override (" + string6 + "): " + string7));
            }
        }
        this.semaphore = new Semaphore(this.maxActiveCount, true);
    }

    public void queue(RunnableThrottleObject runnableThrottleObject) {
        this.queue.add(runnableThrottleObject);
        if (this.isDebugMode()) {
            logger.debug((Object)(this.throttleThreadName + " queued request: " + runnableThrottleObject.getDescription()));
        }
    }

    public void releaseSemaphore() {
        this.semaphore.release();
        if (this.isDebugMode()) {
            logger.debug((Object)("Released semaphore: " + this.throttleThreadName));
        }
    }

    public void terminate() {
        this.running = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Thread.currentThread().setName("RunnableThrottle_" + this.throttleThreadName);
        this.running = true;
        try {
            while (true) {
                if (!this.running) {
                    logger.info((Object)("RunnableThrottle is ending: " + this.throttleThreadName));
                    return;
                }
                try {
                    if (this.isDebugMode()) {
                        logger.debug((Object)("About to read '" + this.throttleThreadName + "' queue. Current size: " + this.queue.size()));
                    }
                    RunnableThrottleObject runnableThrottleObject = this.queue.take();
                    this.semaphore.acquire();
                    if (!this.running) continue;
                    try {
                        this.startThread(runnableThrottleObject);
                    }
                    catch (Throwable throwable) {
                        this.semaphore.release();
                        logger.error((Object)("Error starting " + this.throttleThreadName + " thread."));
                    }
                }
                catch (InterruptedException interruptedException) {
                    logger.warn((Object)("RunnableThrottle interrupted: " + this.throttleThreadName), (Throwable)interruptedException);
                    this.terminate();
                }
            }
        }
        catch (Throwable throwable) {
            logger.error((Object)"RunnableThrottle failed.", throwable);
        }
    }

    private void startThread(RunnableThrottleObject runnableThrottleObject) {
        if (this.isDebugMode()) {
            logger.debug((Object)("RunnableThrottle is starting thread for '" + this.throttleThreadName + "' Object: " + runnableThrottleObject.getDescription()));
        }
        this.runner.startThread(runnableThrottleObject, this);
    }

    private boolean isDebugMode() {
        return logger.isTraceEnabled() || this.debug;
    }
}

