/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.util.HSJvmProperties;
import com.helpsystems.common.core.util.PackageBundleHandler;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.util.WebBundleHandler;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class ResourceBundleHandler {
    private static Logger logger = Logger.getLogger(ResourceBundleHandler.class);
    private String className;
    private PackageBundleHandler parent;

    protected ResourceBundleHandler(String string) {
        this(string, true);
    }

    protected ResourceBundleHandler(String string, boolean bl) {
        PackageBundleHandler packageBundleHandler;
        String string2 = ResourceBundleHandler.extractPackageName(string);
        this.parent = packageBundleHandler = PackageBundleHandler.getOrCreate(string2, bl);
        this.className = ResourceBundleHandler.extractClassName(string);
    }

    public static ResourceBundleHandler getHandler(Class clazz) {
        return ResourceBundleHandler.getHandler(clazz, true);
    }

    public static ResourceBundleHandler getHandler(Class clazz, boolean bl) {
        ValidationHelper.checkForNull("Class", clazz);
        return ResourceBundleHandler.getHandler(clazz.getName(), bl);
    }

    public static ResourceBundleHandler getHandler(String string) {
        return ResourceBundleHandler.getHandler(string, true);
    }

    public static ResourceBundleHandler getHandler(String string, boolean bl) {
        ValidationHelper.checkForNull("Class name", string);
        if (HSJvmProperties.isRuntimeModeDevelopment() && HSJvmProperties.getRbhUrl().length() > 0) {
            return new WebBundleHandler(string);
        }
        return new ResourceBundleHandler(string, bl);
    }

    private static String extractClassName(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    static String extractPackageName(String string) {
        ValidationHelper.checkForNull("Class name", string);
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public String getMsg(String string, Object[] objectArray) {
        String string2 = this.getString(this.className + "_msg_" + string);
        return MessageFormat.format(string2, objectArray);
    }

    public String getMsg(String string) {
        return this.getMsg(string, new Object[0]);
    }

    public String getMsg(String string, Object object) {
        return this.getMsg(string, new Object[]{object});
    }

    public String getMsg(String string, Object object, Object object2) {
        return this.getMsg(string, new Object[]{object, object2});
    }

    public String getMsg(String string, Object object, Object object2, Object object3) {
        return this.getMsg(string, new Object[]{object, object2, object3});
    }

    public String getMsg(String string, Object object, Object object2, Object object3, Object object4) {
        return this.getMsg(string, new Object[]{object, object2, object3, object4});
    }

    public String getStdMsg(String string) {
        return this.getStdMsg(string, new Object[0]);
    }

    public String getStdMsg(String string, Object[] objectArray) {
        String string2 = this.getString("stdMsg_" + string);
        return MessageFormat.format(string2, objectArray);
    }

    public String getStdMsg(String string, Object object) {
        return this.getStdMsg(string, new Object[]{object});
    }

    public String getStdMsg(String string, Object object, Object object2) {
        return this.getStdMsg(string, new Object[]{object, object2});
    }

    public String getStdMsg(String string, Object object, Object object2, Object object3) {
        return this.getStdMsg(string, new Object[]{object, object2, object3});
    }

    public String getStdMsg(String string, Object object, Object object2, Object object3, Object object4) {
        return this.getStdMsg(string, new Object[]{object, object2, object3, object4});
    }

    public String getText(String string) {
        return this.getString(this.className + "_text_" + string);
    }

    public char getTextChar(String string) {
        return this.getText(string).charAt(0);
    }

    public char getStdChar(String string) {
        return this.getStdMsg(string).charAt(0);
    }

    public String getText(int n) {
        return this.getText(String.valueOf(n));
    }

    protected String getString(String string) {
        Object object = this.parent.getObject(string);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string2 = (String)object;
            if (HSJvmProperties.isTestingI18N()) {
                if (string2.length() > 1) {
                    string2 = "(" + string2 + ")";
                } else {
                    logger.trace((Object)("I18N TEST: short string requested: " + string + " -> '" + string2 + "'"));
                }
            }
            return string2;
        }
        throw new ClassCastException(object.getClass().getName() + ", expected String");
    }

    public PackageBundleHandler getPackageParent() {
        return this.parent;
    }
}

