/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.ValidationHelper;

public class RelMod
extends CommonVersionedObject
implements Comparable {
    private static final long serialVersionUID = 6604937777062640010L;
    public static final RelMod UNKNOWN = new RelMod();
    private int release;
    private int modification;
    private int date;

    public RelMod() {
    }

    public RelMod(int n, int n2) {
        if (n < 0 || n > 99) {
            throw new IllegalArgumentException("Invalid release number: " + n);
        }
        if (n2 < 0 || n2 > 99) {
            throw new IllegalArgumentException("Invalid modification number: " + n2);
        }
        this.release = n;
        this.modification = n2;
    }

    public int getRelease() {
        return this.release;
    }

    public int getModification() {
        return this.modification;
    }

    public int getDate() {
        return this.date;
    }

    public static RelMod parse(String string) {
        ValidationHelper.checkForNull("RelMod", string);
        if (string.length() < 6) {
            throw new IllegalArgumentException("RelMod must be at least 6 chars.");
        }
        char c = string.charAt(0);
        char c2 = string.charAt(3);
        if (c != 'R' || c2 != 'M') {
            throw new IllegalArgumentException("Improperly formatted RelMod:" + string);
        }
        RelMod relMod = new RelMod();
        relMod.release = Integer.parseInt(string.substring(1, 3));
        relMod.modification = Integer.parseInt(string.substring(4, 6));
        if (string.length() >= 12) {
            String string2;
            String string3 = string.substring(6);
            int n = -1;
            int n2 = -1;
            try {
                string2 = string3;
                if (string2.length() > 6) {
                    string2 = string2.substring(0, 6);
                }
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                string2 = string3;
                if (string2.length() > 7) {
                    string2 = string2.substring(0, 7);
                }
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n2 > -1) {
                relMod.date = n2;
            } else if (n > -1) {
                relMod.date = n;
            }
        }
        return relMod;
    }

    public static RelMod parse(int n) {
        if (n > 9999 || n < 99) {
            throw new IllegalArgumentException("The number " + n + " is not valid.");
        }
        int n2 = n / 100;
        int n3 = n - n2 * 100;
        return new RelMod(n2, n3);
    }

    public int toInt() {
        return this.release * 100 + this.modification;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        ValidationHelper.checkForNull("Compare", object);
        if (!this.getClass().equals(object.getClass())) {
            throw new IllegalArgumentException("Object " + object.getClass().getName() + " isn't a RelMod.");
        }
        RelMod relMod = (RelMod)object;
        if (relMod.release < this.release) {
            return -1;
        }
        if (relMod.release > this.release) {
            return 1;
        }
        if (relMod.modification < this.modification) {
            return -1;
        }
        if (relMod.modification > this.modification) {
            return 1;
        }
        if (relMod.date < this.date) {
            return -1;
        }
        if (relMod.date > this.date) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('R');
        if (this.release < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(this.release);
        stringBuffer.append('M');
        if (this.modification < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(this.modification);
        if (this.date > 0) {
            if (this.date < 1000000) {
                stringBuffer.append("0");
            }
            stringBuffer.append(this.date);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        System.out.println(RelMod.parse(stringArray[0]));
    }
}

