/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.util.ThreadSession;
import com.helpsystems.common.core.util.ValidationHelper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class PackageBundleHandler {
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private static final Logger logger = Logger.getLogger(PackageBundleHandler.class);
    private static final String UNIVERSAL_RESOURCE_NAME = "com.helpsystems.common.core.util.UniversalResources";
    private static Map<String, PackageBundleHandler> handlerMap = new HashMap<String, PackageBundleHandler>(500, 0.75f);
    private PackageBundleHandler parent;
    private Map<Locale, ResourceBundle> localeMap;
    private String resourceName;
    private ClassLoader cl;

    protected PackageBundleHandler(String string, boolean bl) {
        block3: {
            this.resourceName = string;
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                ResourceBundle resourceBundle = ResourceBundle.getBundle(string, DEFAULT_LOCALE, classLoader);
                this.cl = resourceBundle.getClass().getClassLoader();
                this.localeMap = new HashMap<Locale, ResourceBundle>();
                this.localeMap.put(DEFAULT_LOCALE, resourceBundle);
            }
            catch (MissingResourceException missingResourceException) {
                if (!bl) break block3;
                throw new RuntimeException("Cannot find the Resource Bundle for base name " + string + ".");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PackageBundleHandler getOrCreate(String string, boolean bl) {
        PackageBundleHandler packageBundleHandler = null;
        Map<String, PackageBundleHandler> map = handlerMap;
        synchronized (map) {
            packageBundleHandler = handlerMap.get(string);
        }
        if (packageBundleHandler != null) {
            return packageBundleHandler;
        }
        int n = string.lastIndexOf(".");
        String string2 = string.substring(n + 1, n + 2).toUpperCase() + string.substring(n + 2);
        String string3 = string + "." + string2 + "Resources";
        packageBundleHandler = new PackageBundleHandler(string3, bl);
        String string4 = PackageBundleHandler.extractParentPackageName(string);
        packageBundleHandler.parent = PackageBundleHandler.getOrCreate(string4, false);
        Map<String, PackageBundleHandler> map2 = handlerMap;
        synchronized (map2) {
            handlerMap.put(string, packageBundleHandler);
        }
        return packageBundleHandler;
    }

    public Object getObject(String string, boolean bl) {
        block3: {
            ThreadSession threadSession = ThreadSession.getSession();
            if (threadSession != null) {
                Locale locale = threadSession.getLocale();
                try {
                    return this.getObject(string, locale, bl);
                }
                catch (RuntimeException runtimeException) {
                    if (!DEFAULT_LOCALE.equals(locale)) break block3;
                    throw runtimeException;
                }
            }
        }
        return this.getObject(string, DEFAULT_LOCALE, bl);
    }

    public Object getObject(String string) {
        return this.getObject(string, true);
    }

    protected Object getObject(String string, Locale locale, boolean bl) {
        Locale locale2 = null;
        MissingResourceException missingResourceException = null;
        locale2 = locale == null ? DEFAULT_LOCALE : locale;
        ResourceBundle resourceBundle = null;
        if (this.localeMap != null) {
            resourceBundle = this.localeMap.get(locale2);
            if (resourceBundle == null) {
                try {
                    resourceBundle = ResourceBundle.getBundle(this.resourceName, locale2, this.cl);
                    this.localeMap.put(locale2, resourceBundle);
                }
                catch (MissingResourceException missingResourceException2) {
                    logger.debug((Object)("Unable to load package resource " + this.resourceName + " for locale " + locale2), (Throwable)missingResourceException2);
                }
            }
            if (resourceBundle == null && !locale2.equals(DEFAULT_LOCALE)) {
                resourceBundle = this.localeMap.get(DEFAULT_LOCALE);
            }
        }
        if (resourceBundle != null) {
            try {
                return resourceBundle.getObject(string);
            }
            catch (MissingResourceException missingResourceException3) {
                missingResourceException = missingResourceException3;
            }
        }
        if (bl && this.parent != null) {
            return this.parent.getObject(string, locale, true);
        }
        if (missingResourceException == null) {
            missingResourceException = new MissingResourceException("Key '" + string + "' not found in " + "Resource Bundle " + this.resourceName + " for locale " + locale, this.resourceName, string);
        }
        throw missingResourceException;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    private static String extractParentPackageName(String string) {
        ValidationHelper.checkForNull("Package name", string);
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return "";
        }
        return string.substring(0, n);
    }

    public PackageBundleHandler getPackageParent() {
        return this.parent;
    }

    static {
        handlerMap.put("", new PackageBundleHandler(UNIVERSAL_RESOURCE_NAME, true));
    }
}

