/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.busobj.VersionedObject;
import com.helpsystems.common.core.util.NativeSzInfo;
import com.helpsystems.common.core.util.ValidationHelper;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class NativeSz {
    private static final Logger logger = Logger.getLogger(NativeSz.class);
    public static final String LIBRARY_NAME;
    private static HashMap classloaderCache;
    public static final byte OBJECT_FIELD = 0;
    public static final byte BOOLEAN_FIELD = 1;
    public static final byte WRAPPED_BOOLEAN_FIELD = -1;
    public static final byte BYTE_FIELD = 2;
    public static final byte WRAPPED_BYTE_FIELD = -2;
    public static final byte SHORT_FIELD = 3;
    public static final byte WRAPPED_SHORT_FIELD = -3;
    public static final byte CHARACTER_FIELD = 4;
    public static final byte WRAPPED_CHARACTER_FIELD = -4;
    public static final byte INTEGER_FIELD = 5;
    public static final byte WRAPPED_INTEGER_FIELD = -5;
    public static final byte LONG_FIELD = 6;
    public static final byte WRAPPED_LONG_FIELD = -6;
    public static final byte FLOAT_FIELD = 7;
    public static final byte WRAPPED_FLOAT_FIELD = -7;
    public static final byte DOUBLE_FIELD = 8;
    public static final byte WRAPPED_DOUBLE_FIELD = -8;

    private NativeSz() {
    }

    private static void loadNativeLibraryImpl() throws UnsatisfiedLinkError {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(LIBRARY_NAME);
        String string = System.getProperty("java.specification.version");
        String string2 = System.getProperty("sun.arch.data.model");
        if (string2 != null && string2.length() > 0) {
            if (string != null && string.length() > 0) {
                arrayList.add(LIBRARY_NAME + string2 + "_j" + string);
            }
            arrayList.add(LIBRARY_NAME + string2);
        }
        if (string != null && string.length() > 0) {
            arrayList.add(LIBRARY_NAME + "_j" + string);
        }
        UnsatisfiedLinkError unsatisfiedLinkError = null;
        for (String string3 : arrayList) {
            try {
                System.loadLibrary(string3);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                NativeSzInfo.addFailure(unsatisfiedLinkError2);
                String string4 = unsatisfiedLinkError2.getMessage();
                if (string4.indexOf("already loaded in another classloader") > 0) {
                    return;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Unable to load native library " + string3), (Throwable)unsatisfiedLinkError2);
                }
                unsatisfiedLinkError = unsatisfiedLinkError2;
            }
        }
        if (unsatisfiedLinkError != null) {
            NativeSz.printAndThrow(unsatisfiedLinkError);
        }
    }

    private static void printAndThrow(UnsatisfiedLinkError unsatisfiedLinkError) throws UnsatisfiedLinkError {
        File file = new File(".");
        String string = "Unable to load library: " + LIBRARY_NAME + "\nCurrent working dir: " + file.getAbsolutePath() + "\njava.library.path: " + System.getProperty("java.library.path") + "\nos.arch: " + System.getProperty("os.arch") + "\nos.name: " + System.getProperty("os.name") + "\nos.version: " + System.getProperty("os.version") + "\nsun.arch.data.model: " + System.getProperty("sun.arch.data.model") + "\njava.specification.version: " + System.getProperty("java.specification.version");
        logger.fatal((Object)string, (Throwable)unsatisfiedLinkError);
        System.err.println(string);
        throw unsatisfiedLinkError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map findClassMap(ClassLoader classLoader) {
        HashMap hashMap = null;
        HashMap hashMap2 = classloaderCache;
        synchronized (hashMap2) {
            hashMap = (HashMap)classloaderCache.get(classLoader);
            if (hashMap == null) {
                hashMap = new HashMap();
                classloaderCache.put(classLoader, hashMap);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map findFieldMap(Class clazz) throws IOException {
        Map map = NativeSz.findClassMap(clazz.getClassLoader());
        HashMap<String, Field> hashMap = null;
        Map map2 = map;
        synchronized (map2) {
            hashMap = (HashMap<String, Field>)map.get(clazz);
            if (hashMap == null) {
                hashMap = new HashMap<String, Field>();
                for (Class clazz2 = clazz; clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
                    Field[] fieldArray = clazz2.getDeclaredFields();
                    for (int i = 0; i < fieldArray.length; ++i) {
                        Field field = fieldArray[i];
                        int n = field.getModifiers();
                        if (Modifier.isStatic(n) || Modifier.isTransient(n)) continue;
                        if (hashMap.get(field.getName()) != null) {
                            Field field2 = (Field)hashMap.get(field.getName());
                            String string = field2.getDeclaringClass().getName();
                            String string2 = field.getDeclaringClass().getName();
                            throw new NotSerializableException("The field '" + field.getName() + "' is defined both in " + string + " and " + string2);
                        }
                        hashMap.put(field.getName(), field);
                    }
                }
                map.put(clazz, hashMap);
            }
        }
        return hashMap;
    }

    private static Field[] findFieldsForClass(Class clazz) throws IOException {
        Map map = NativeSz.findFieldMap(clazz);
        Collection collection = map.values();
        Field[] fieldArray = new Field[collection.size()];
        collection.toArray(fieldArray);
        return fieldArray;
    }

    public static void copyStreamToMap(ObjectInput objectInput, VersionedObject.ObjectFieldMap objectFieldMap) throws IOException, ClassNotFoundException {
        String string;
        ValidationHelper.checkForNull("Object Input", objectInput);
        ValidationHelper.checkForNull("Object Field Map", objectFieldMap);
        while ((string = objectInput.readUTF()).length() != 0) {
            byte by = objectInput.readByte();
            Object object = null;
            switch (by) {
                case 1: {
                    object = new Boolean(objectInput.readBoolean());
                    break;
                }
                case 2: {
                    object = new Byte(objectInput.readByte());
                    break;
                }
                case 3: {
                    object = new Short(objectInput.readShort());
                    break;
                }
                case 4: {
                    object = new Character(objectInput.readChar());
                    break;
                }
                case 5: {
                    object = new Integer(objectInput.readInt());
                    break;
                }
                case 6: {
                    object = new Long(objectInput.readLong());
                    break;
                }
                case 7: {
                    object = new Float(objectInput.readFloat());
                    break;
                }
                case 8: {
                    object = new Double(objectInput.readDouble());
                    break;
                }
                case 0: {
                    object = objectInput.readObject();
                    break;
                }
                default: {
                    throw new IOException("Unknown field type: " + by);
                }
            }
            objectFieldMap.put(string, object);
        }
    }

    public static void copyFieldsToMap(Object object, VersionedObject.ObjectFieldMap objectFieldMap) throws IOException {
        ValidationHelper.checkForNull("Object", object);
        ValidationHelper.checkForNull("Object Field Map", objectFieldMap);
        Field[] fieldArray = NativeSz.findFieldsForClass(object.getClass());
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            Class<?> clazz = field.getType();
            String string = field.getName();
            Object object2 = null;
            object2 = clazz.equals(Boolean.TYPE) ? new Boolean(NativeSz.getBooleanField(field, object)) : (clazz.equals(Byte.TYPE) ? new Byte(NativeSz.getByteField(field, object)) : (clazz.equals(Short.TYPE) ? new Short(NativeSz.getShortField(field, object)) : (clazz.equals(Character.TYPE) ? new Character(NativeSz.getCharField(field, object)) : (clazz.equals(Integer.TYPE) ? new Integer(NativeSz.getIntField(field, object)) : (clazz.equals(Long.TYPE) ? new Long(NativeSz.getLongField(field, object)) : (clazz.equals(Float.TYPE) ? new Float(NativeSz.getFloatField(field, object)) : (clazz.equals(Double.TYPE) ? new Double(NativeSz.getDoubleField(field, object)) : NativeSz.getObjectField(field, object))))))));
            objectFieldMap.put(string, object2);
        }
    }

    public static void copyMapToObject(Map map, Object object) throws IOException {
        ValidationHelper.checkForNull("Field Map", map);
        ValidationHelper.checkForNull("Target", object);
        Map map2 = NativeSz.findFieldMap(object.getClass());
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            Field field = (Field)map2.get(string);
            if (field == null) continue;
            Class<?> clazz = field.getType();
            if (clazz.equals(Boolean.TYPE)) {
                boolean bl = false;
                if (v != null) {
                    bl = (Boolean)v;
                }
                NativeSz.setBooleanField(field, object, bl);
                continue;
            }
            if (clazz.equals(Byte.TYPE)) {
                byte by = 0;
                if (v != null) {
                    by = (Byte)v;
                }
                NativeSz.setByteField(field, object, by);
                continue;
            }
            if (clazz.equals(Short.TYPE)) {
                short s = 0;
                if (v != null) {
                    s = (Short)v;
                }
                NativeSz.setShortField(field, object, s);
                continue;
            }
            if (clazz.equals(Character.TYPE)) {
                char c = '\u0000';
                if (v != null) {
                    c = ((Character)v).charValue();
                }
                NativeSz.setCharField(field, object, c);
                continue;
            }
            if (clazz.equals(Integer.TYPE)) {
                int n = 0;
                if (v != null) {
                    n = (Integer)v;
                }
                NativeSz.setIntField(field, object, n);
                continue;
            }
            if (clazz.equals(Long.TYPE)) {
                long l = 0L;
                if (v != null) {
                    l = (Long)v;
                }
                NativeSz.setLongField(field, object, l);
                continue;
            }
            if (clazz.equals(Float.TYPE)) {
                float f = 0.0f;
                if (v != null) {
                    f = ((Float)v).floatValue();
                }
                NativeSz.setFloatField(field, object, f);
                continue;
            }
            if (clazz.equals(Double.TYPE)) {
                double d = 0.0;
                if (v != null) {
                    d = (Double)v;
                }
                NativeSz.setDoubleField(field, object, d);
                continue;
            }
            NativeSz.setObjectField(field, object, v);
        }
    }

    public static void readObject(ObjectInput objectInput, Object object) throws IOException, ClassNotFoundException {
        String string;
        if (objectInput == null) {
            throw new NullPointerException("ObjectInput is null.");
        }
        if (object == null) {
            throw new NullPointerException("Object is null.");
        }
        Map map = NativeSz.findFieldMap(object.getClass());
        block11: while ((string = objectInput.readUTF()).length() != 0) {
            Field field = (Field)map.get(string);
            Class<?> clazz = null;
            if (field != null) {
                clazz = field.getType();
            }
            int n = objectInput.readByte();
            Object object2 = null;
            if (n == 0) {
                object2 = objectInput.readObject();
                if (Boolean.class.equals(object2)) {
                    n = -1;
                }
                if (Byte.class.equals(object2)) {
                    n = -2;
                }
                if (Short.class.equals(object2)) {
                    n = -3;
                }
                if (Character.class.equals(object2)) {
                    n = -4;
                }
                if (Integer.class.equals(object2)) {
                    n = -5;
                }
                if (Long.class.equals(object2)) {
                    n = -6;
                }
                if (Float.class.equals(object2)) {
                    n = -7;
                }
                if (Double.class.equals(object2)) {
                    n = -8;
                }
            }
            switch (n) {
                case -1: 
                case 1: {
                    boolean bl = n == 1 ? objectInput.readBoolean() : ((Boolean)object2).booleanValue();
                    if (field == null) continue block11;
                    if (clazz.equals(Boolean.TYPE)) {
                        NativeSz.setBooleanField(field, object, bl);
                        continue block11;
                    }
                    throw new IOException("Field " + string + " in the stream is boolean, local class is " + clazz.getName());
                }
                case -2: 
                case 2: {
                    byte by = n == 2 ? objectInput.readByte() : ((Byte)object2).byteValue();
                    if (field == null) continue block11;
                    if (clazz.equals(Byte.TYPE)) {
                        NativeSz.setByteField(field, object, by);
                        continue block11;
                    }
                    throw new IOException("Field " + string + " in the stream is byte, local class is " + clazz.getName());
                }
                case -3: 
                case 3: {
                    short s = n == 3 ? objectInput.readShort() : ((Short)object2).shortValue();
                    if (field == null) continue block11;
                    if (clazz.equals(Short.TYPE)) {
                        NativeSz.setShortField(field, object, s);
                        continue block11;
                    }
                    throw new IOException("Field " + string + " in the stream is short, local class is " + clazz.getName());
                }
                case -4: 
                case 4: {
                    char c = n == 4 ? objectInput.readChar() : ((Character)object2).charValue();
                    if (field == null) continue block11;
                    if (clazz.equals(Character.TYPE)) {
                        NativeSz.setCharField(field, object, c);
                        continue block11;
                    }
                    throw new IOException("Field " + string + " in the stream is char, local class is " + clazz.getName());
                }
                case -5: 
                case 5: {
                    int n2 = n == 5 ? objectInput.readInt() : ((Integer)object2).intValue();
                    if (field == null) continue block11;
                    if (clazz.equals(Integer.TYPE)) {
                        NativeSz.setIntField(field, object, n2);
                        continue block11;
                    }
                    throw new IOException("Field " + string + " in the stream is int, local class is " + clazz.getName());
                }
                case -6: 
                case 6: {
                    long l = n == 6 ? objectInput.readLong() : ((Long)object2).longValue();
                    if (field == null) continue block11;
                    if (clazz.equals(Long.TYPE)) {
                        NativeSz.setLongField(field, object, l);
                        continue block11;
                    }
                    throw new IOException("Field " + string + " in the stream is long, local class is " + clazz.getName());
                }
                case -7: 
                case 7: {
                    float f = n == 7 ? objectInput.readFloat() : ((Float)object2).floatValue();
                    if (field == null) continue block11;
                    if (clazz.equals(Float.TYPE)) {
                        NativeSz.setFloatField(field, object, f);
                        continue block11;
                    }
                    throw new IOException("Field " + string + " in the stream is float, local class is " + clazz.getName());
                }
                case -8: 
                case 8: {
                    double d = n == 8 ? objectInput.readDouble() : ((Double)object2).doubleValue();
                    if (field == null) continue block11;
                    if (clazz.equals(Double.TYPE)) {
                        NativeSz.setDoubleField(field, object, d);
                        continue block11;
                    }
                    throw new IOException("Field " + string + " in the stream is double, local class is " + clazz.getName());
                }
                case 0: {
                    if (field == null) continue block11;
                    NativeSz.setObjectField(field, object, object2);
                    continue block11;
                }
            }
            throw new IOException("Unknown field type: " + n);
        }
    }

    public static void writeMapToStream(ObjectOutput objectOutput, Map map) throws IOException {
        if (objectOutput == null) {
            throw new NullPointerException("ObjectOutput is null.");
        }
        if (map == null) {
            throw new NullPointerException("Map is null.");
        }
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            objectOutput.writeUTF(string);
            objectOutput.writeByte(0);
            objectOutput.writeObject(entry.getValue());
        }
        objectOutput.writeUTF("");
    }

    public static void writeObject(ObjectOutput objectOutput, Object object) throws IOException {
        if (objectOutput == null) {
            throw new NullPointerException("ObjectOutput is null.");
        }
        if (object == null) {
            throw new NullPointerException("Object is null.");
        }
        Field[] fieldArray = NativeSz.findFieldsForClass(object.getClass());
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            Class<?> clazz = field.getType();
            objectOutput.writeUTF(field.getName());
            if (clazz.equals(Boolean.TYPE)) {
                objectOutput.writeByte(1);
                objectOutput.writeBoolean(NativeSz.getBooleanField(field, object));
                continue;
            }
            if (clazz.equals(Byte.TYPE)) {
                objectOutput.writeByte(2);
                objectOutput.writeByte(NativeSz.getByteField(field, object));
                continue;
            }
            if (clazz.equals(Short.TYPE)) {
                objectOutput.writeByte(3);
                objectOutput.writeShort(NativeSz.getShortField(field, object));
                continue;
            }
            if (clazz.equals(Character.TYPE)) {
                objectOutput.writeByte(4);
                objectOutput.writeChar(NativeSz.getCharField(field, object));
                continue;
            }
            if (clazz.equals(Integer.TYPE)) {
                objectOutput.writeByte(5);
                objectOutput.writeInt(NativeSz.getIntField(field, object));
                continue;
            }
            if (clazz.equals(Long.TYPE)) {
                objectOutput.writeByte(6);
                objectOutput.writeLong(NativeSz.getLongField(field, object));
                continue;
            }
            if (clazz.equals(Float.TYPE)) {
                objectOutput.writeByte(7);
                objectOutput.writeFloat(NativeSz.getFloatField(field, object));
                continue;
            }
            if (clazz.equals(Double.TYPE)) {
                objectOutput.writeByte(8);
                objectOutput.writeDouble(NativeSz.getDoubleField(field, object));
                continue;
            }
            Object object2 = NativeSz.getObjectField(field, object);
            objectOutput.writeByte(0);
            objectOutput.writeObject(object2);
        }
        objectOutput.writeUTF("");
    }

    public static native boolean getBooleanField(Field var0, Object var1);

    public static native byte getByteField(Field var0, Object var1);

    public static native short getShortField(Field var0, Object var1);

    public static native char getCharField(Field var0, Object var1);

    public static native int getIntField(Field var0, Object var1);

    public static native long getLongField(Field var0, Object var1);

    public static native float getFloatField(Field var0, Object var1);

    public static native double getDoubleField(Field var0, Object var1);

    public static native Object getObjectField(Field var0, Object var1);

    public static native void setBooleanField(Field var0, Object var1, boolean var2);

    public static native void setByteField(Field var0, Object var1, byte var2);

    public static native void setShortField(Field var0, Object var1, short var2);

    public static native void setCharField(Field var0, Object var1, char var2);

    public static native void setIntField(Field var0, Object var1, int var2);

    public static native void setLongField(Field var0, Object var1, long var2);

    public static native void setFloatField(Field var0, Object var1, float var2);

    public static native void setDoubleField(Field var0, Object var1, double var2);

    public static native void setObjectField(Field var0, Object var1, Object var2);

    public static native int getNativeVersion();

    public static native String getStreamVersion();

    static {
        String string = "nativeSz";
        if ("OpenVMS".equals(System.getProperty("os.name"))) {
            System.out.println("Using OpenVMS.");
            string = "nativesz";
        }
        LIBRARY_NAME = string;
        classloaderCache = new HashMap();
        NativeSz.loadNativeLibraryImpl();
    }
}

