/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.util.InterruptibleProcess;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import javax.xml.bind.DatatypeConverter;

public class HttpFileTransfer
implements InterruptibleProcess {
    public static final String HTTP_GET = "GET";
    public static final String HTTP_POST = "POST";
    private boolean interrupted = false;

    protected String encodeCredentials(String string, String string2) {
        String string3 = string2;
        if (string3 == null) {
            string3 = "";
        }
        String string4 = string + ":" + string3;
        byte[] byArray = string4.getBytes();
        String string5 = DatatypeConverter.printBase64Binary((byte[])byArray);
        return string5;
    }

    public void fetch(URL uRL, String string, File file) throws IOException {
        this.fetch(uRL, string, file, null, null);
    }

    @Override
    public boolean wasInterrupted() {
        return this.interrupted;
    }

    @Override
    public boolean isInterruptible() {
        return true;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetch(URL uRL, String string, File file, String string2, String string3) throws IOException {
        this.interrupted = false;
        if (file == null) {
            throw new NullPointerException("The Output file passed in was null.");
        }
        HttpURLConnection httpURLConnection = this.openConnection(uRL, string, string2, string3);
        int n = this.getResponseCookie(httpURLConnection, false);
        if (n != 200) {
            if (n == 401) {
                throw new IOException("The login information is not valid.");
            }
            if (n == 404) {
                throw new IOException("The file was not found on the server.");
            }
            throw new IOException("The server is not able to send the file. Response code: " + n);
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[50000];
            while (!this.interrupted) {
                int n2 = bufferedInputStream.read(byArray);
                if (n2 < 0) {
                    break;
                }
                fileOutputStream.write(byArray, 0, n2);
            }
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Throwable throwable) {}
            try {
                bufferedInputStream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public int getResponseCode(URL uRL, String string, String string2, String string3) throws IOException {
        HttpURLConnection httpURLConnection = this.openConnection(uRL, string, string2, string3);
        int n = httpURLConnection.getResponseCode();
        return n;
    }

    public int getCookieResponseCode(URL uRL, String string, String string2, String string3) throws IOException {
        HttpURLConnection httpURLConnection = this.openConnection(uRL, string, string2, string3);
        return this.getResponseCookie(httpURLConnection, true);
    }

    public int getResponseCookie(HttpURLConnection httpURLConnection, boolean bl) throws IOException {
        String string = httpURLConnection.getHeaderField("set-cookie");
        if (string == null) {
            if (bl) {
                throw new IOException("Cookie 'response_code' not found in the response.");
            }
            return 200;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n == -1 || n == 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = "";
            if (n + 1 < string2.length()) {
                string4 = string2.substring(n + 1);
            }
            if (!"response_code".equals(string3)) continue;
            try {
                return Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("Cookie 'response_code' returned non-numeric value: " + string4);
            }
        }
        if (bl) {
            throw new IOException("Cookie 'response_code' not found in the response.");
        }
        return 200;
    }

    public static void main(String[] stringArray) {
        if (stringArray == null || stringArray.length < 3) {
            HttpFileTransfer.printHelp();
            return;
        }
        URL uRL = null;
        try {
            uRL = new URL(stringArray[0]);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("The URL " + stringArray[0] + " doesn't appear to be valid.");
            System.err.println(malformedURLException.getClass().getName() + ": " + malformedURLException.getMessage());
            return;
        }
        HttpFileTransfer httpFileTransfer = new HttpFileTransfer();
        String string = null;
        String string2 = null;
        if (stringArray.length > 3) {
            string = stringArray[3];
        }
        if (stringArray.length > 4) {
            string2 = stringArray[4];
        }
        try {
            httpFileTransfer.fetch(uRL, stringArray[1], new File(stringArray[2]), string, string2);
        }
        catch (Exception exception) {
            System.err.println("An error occurred while trying to perform the HTTP action.");
            exception.printStackTrace();
        }
    }

    public static void printHelp() {
        System.out.println("Need 3 or more params: URL HttpMode OutputFile [username password]");
        System.out.println("\tURL is the url to be retrieved.");
        System.out.println("\tHttpMode can be either GET or POST.");
        System.out.println("\tOutputFile is the file to which the data is saved.");
        System.out.println("\tUsername (optional) user credential for a secure web page.");
        System.out.println("\tPassword (optional) password credential for a secure web page.");
    }

    protected HttpURLConnection openConnection(URL uRL, String string, String string2, String string3) throws IOException {
        if (uRL == null) {
            throw new NullPointerException("The URL passed in was null.");
        }
        if (string == null) {
            throw new NullPointerException("The HttpMode passed in was null.");
        }
        boolean bl = false;
        if (string.equals(HTTP_POST) || string.equals(HTTP_GET)) {
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("The HTTP Mode " + string + " is not valid. Try 'GET' or 'POST'.");
        }
        String string4 = null;
        if (string2 != null) {
            string4 = this.encodeCredentials(string2, string3);
        }
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setRequestProperty("Connection", "Keep-Alive");
        uRLConnection.setRequestProperty("Proxy-Connection", "Keep-Alive");
        uRLConnection.setRequestProperty("Cache-Control", "no-cache");
        if (string4 != null) {
            uRLConnection.setRequestProperty("Authorization", "Basic " + string4);
        }
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setRequestMethod(string);
            HttpURLConnection.setFollowRedirects(true);
            httpURLConnection.setInstanceFollowRedirects(true);
            return httpURLConnection;
        }
        throw new IOException("An invalid protocol was specified. Did not get a Http Connection");
    }
}

