/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.util.ValidationHelper;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class DurableMap {
    private static final String SUFFIX = ".sz";
    private String baseName;
    private File dir;
    private Object lock;
    private FilenameFilter myFilenameFilter;

    public DurableMap(String string, String string2) throws IOException {
        ValidationHelper.checkForNullAndBlank("Base filename", string2);
        this.baseName = string2 + "_";
        this.lock = new Object();
        String string3 = string;
        if (string == null) {
            string3 = System.getProperty("user.dir");
        }
        this.dir = new File(string3);
        if (!this.dir.exists() && !this.dir.mkdir()) {
            throw new IOException("Directory " + this.dir.getAbsolutePath() + " does not exist.");
        }
        if (!this.dir.isDirectory()) {
            throw new IOException(this.dir.getAbsolutePath() + " is not a directory.");
        }
        this.myFilenameFilter = new MyFilenameFilter();
    }

    private File[] listFiles() {
        return this.dir.listFiles(this.myFilenameFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        int n = 0;
        String string = null;
        Object object = this.lock;
        synchronized (object) {
            for (File file : this.listFiles()) {
                if (file.delete()) continue;
                ++n;
                string = file.getAbsolutePath();
            }
        }
        if (n == 1) {
            throw new IOException("Unable to delete file " + string);
        }
        if (n > 1) {
            throw new IOException("Unable to delete " + n + " files");
        }
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private File makeFile(String string) {
        return new File(this.dir, this.baseName + string + SUFFIX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String string, Serializable serializable) throws IOException {
        File file = this.makeFile(string);
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        Object object = this.lock;
        synchronized (object) {
            try {
                fileOutputStream = new FileOutputStream(file);
                objectOutputStream = new ObjectOutputStream(fileOutputStream);
                objectOutputStream.writeObject(serializable);
            }
            catch (Throwable throwable) {
                DurableMap.close(fileOutputStream);
                DurableMap.close(objectOutputStream);
                throw throwable;
            }
            DurableMap.close(fileOutputStream);
            DurableMap.close(objectOutputStream);
        }
    }

    public Serializable get(String string) throws IOException {
        File file = this.makeFile(string);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        Object object = this.lock;
        synchronized (object) {
            Serializable serializable;
            try {
                fileInputStream = new FileInputStream(file);
                objectInputStream = new ObjectInputStream(fileInputStream);
                serializable = (Serializable)objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    IOException iOException = new IOException("Unable to reconstruct an object from the file " + file.getAbsolutePath());
                    iOException.initCause(classNotFoundException);
                    throw iOException;
                }
                catch (Throwable throwable) {
                    DurableMap.close(fileInputStream);
                    DurableMap.close(objectInputStream);
                    throw throwable;
                }
            }
            DurableMap.close(fileInputStream);
            DurableMap.close(objectInputStream);
            return serializable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) throws IOException {
        File file = this.makeFile(string);
        if (!file.exists()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!file.delete()) {
                throw new IOException("Unable to delete file " + file.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        int n = this.baseName.length();
        Object object = this.lock;
        synchronized (object) {
            for (File file : this.listFiles()) {
                String string = file.getName();
                int n2 = string.length() - SUFFIX.length();
                hashSet.add(string.substring(n, n2));
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.listFiles().length;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        final DurableMap durableMap = new DurableMap("/tmp", "blah");
        final Date date = new Date();
        System.out.println("Starting at: " + date);
        durableMap.clear();
        Thread thread = new Thread(){

            @Override
            public void run() {
                this.setName("Pusher Thread");
                int n = 0;
                while (n < 10000) {
                    if (n % 100 == 0) {
                        try {
                            Thread.sleep(125L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    String string = "Test String " + n;
                    try {
                        durableMap.put(Integer.toString(n++), (Serializable)((Object)string));
                    }
                    catch (IOException iOException) {
                        System.out.println(iOException);
                        n = Integer.MAX_VALUE;
                    }
                }
            }
        };
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                this.setName("Popper Thread");
                int n = 0;
                while (n < 10000) {
                    try {
                        Serializable serializable;
                        if (n % 100 == 0) {
                            try {
                                Thread.sleep(125L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                        if ((serializable = durableMap.get(Integer.toString(n))) == null) continue;
                        durableMap.remove(Integer.toString(n));
                        ++n;
                    }
                    catch (EOFException eOFException) {
                    }
                    catch (IOException iOException) {
                        System.out.println(iOException);
                        n = Integer.MAX_VALUE;
                    }
                }
                long l = 0L;
                try {
                    l = durableMap.size();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (l > 0L) {
                    System.out.println("Done.  /tmp should be empty, but is not...");
                } else {
                    System.out.println("Done.  /tmp is empty");
                }
                Date date2 = new Date();
                long l2 = date2.getTime() - date.getTime();
                System.out.println("Ending at: " + date2);
                System.out.println("Elapsed time: " + l2 / 1000L);
                System.exit(-1);
            }
        };
        Thread thread3 = new Thread(){

            @Override
            public void run() {
                this.setName("Watcher Thread");
                boolean bl = false;
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(250L);
                            System.out.println("Watcher is reporting Map size: " + durableMap.size());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        System.exit(-3);
                        continue;
                    }
                    break;
                }
            }
        };
        thread.start();
        thread2.start();
        thread3.start();
    }

    class MyFilenameFilter
    implements FilenameFilter {
        MyFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String string) {
            if (!file.equals(DurableMap.this.dir)) {
                return false;
            }
            return string.startsWith(DurableMap.this.baseName) && string.endsWith(DurableMap.SUFFIX);
        }
    }
}

