/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.util;

import com.helpsystems.common.core.busobj.LocalizedDate;
import com.helpsystems.common.core.dm.IApplicationConfigManager;
import com.helpsystems.common.core.util.ValidationHelper;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.MissingResourceException;
import java.util.TimeZone;

public abstract class DateTranslator {
    public static final int TIME_FORMAT_HHMM = 0;
    public static final int TIME_FORMAT_HHMMSS = 1;
    private static final int MAX_YEAR = 9999;
    private static final int MAX_MONTH = 12;
    private static final int MAX_DAY = 31;
    private static final String YEAR_LABEL = "Year";
    private static final String MONTH_LABEL = "Month";
    private static final String DAY_LABEL = "Day";
    public static final String DATE_SEPARATOR = "DateSeparator";
    public static final String TIME_SEPARATOR = "TimeSeparator";
    public static final String DATE_FORMAT_INDEX = "DateFormatIndex";
    public static final int MDY = 0;
    public static final int DMY = 1;
    public static final int YMD = 2;
    private static SimpleDateFormat dateFormatYY;
    private static SimpleDateFormat dateFormatYYYY;
    private static SimpleDateFormat dateFormatNoDay;
    private static SimpleDateFormat dateFormatNoYear;
    private static SimpleDateFormat timeFormatHHMM;
    private static SimpleDateFormat timeFormatHHMMSS;
    private static SimpleDateFormat timeFormatHHMMSSms;
    private static Object changeLock;
    private static int datePattern;
    private static char dateSeparator;
    private static char timeSeparator;
    private static final DateFormat TZ_FORMAT;
    private static IApplicationConfigManager configManager;

    public static String packDate(Date date) {
        return DateTranslator.packDate(date, null);
    }

    public static String packDate(Date date, TimeZone timeZone) {
        StringBuilder stringBuilder = new StringBuilder(20);
        Calendar calendar = DateTranslator.getCalendar(timeZone);
        calendar.setTime(date);
        int n = calendar.get(1) - 1900;
        if (n >= 100) {
            stringBuilder.append(n);
        } else {
            stringBuilder.append("0");
            stringBuilder.append(n);
        }
        int n2 = calendar.get(2) + 1;
        if (n2 < 10) {
            stringBuilder.append("0");
        }
        stringBuilder.append(n2);
        int n3 = calendar.get(5);
        if (n3 < 10) {
            stringBuilder.append("0");
        }
        stringBuilder.append(n3);
        return stringBuilder.toString();
    }

    private static Calendar getCalendar(TimeZone timeZone) {
        Calendar calendar = null;
        calendar = timeZone != null ? Calendar.getInstance(timeZone) : Calendar.getInstance();
        return calendar;
    }

    public static String packTime(Date date) {
        return DateTranslator.packTime(date, 0, null);
    }

    public static String packTime(Date date, TimeZone timeZone) {
        return DateTranslator.packTime(date, 0, timeZone);
    }

    public static String packTime(Date date, int n) {
        return DateTranslator.packTime(date, n, null);
    }

    public static String packTime(Date date, int n, TimeZone timeZone) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Time Format is invalid.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        Calendar calendar = DateTranslator.getCalendar(timeZone);
        calendar.setTime(date);
        stringBuffer.append(calendar.get(11));
        int n2 = calendar.get(12);
        if (n2 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n2);
        if (n == 1) {
            int n3 = calendar.get(13);
            if (n3 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n3);
        }
        return stringBuffer.toString();
    }

    public static Date unpackDate(String string) {
        if (string.length() == 11) {
            String string2 = string.substring(0, 7);
            String string3 = string.substring(7);
            return DateTranslator.unpackDate(string2, string3, 0);
        }
        if (string.length() == 13) {
            String string4 = string.substring(0, 7);
            String string5 = string.substring(7);
            return DateTranslator.unpackDate(string4, string5, 1);
        }
        throw new IllegalArgumentException("The packed timestamp " + string + " is not valid.");
    }

    public static Date unpackDate(String string, String string2) {
        return DateTranslator.unpackDate(string, string2, 0);
    }

    public static Date unpackDate(String string, String string2, int n) {
        int n2;
        String string3 = string;
        String string4 = string2;
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Time Format is invalid.");
        }
        if (string3 == null) {
            string3 = "0";
        }
        if (string4 == null) {
            string4 = "0";
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.clear();
        boolean bl = false;
        if (string3.equals("0")) {
            string3 = "0000101";
            bl = true;
        }
        if (string3.length() < 7) {
            StringBuffer stringBuffer = new StringBuffer(string3);
            while (stringBuffer.length() < 7) {
                stringBuffer.insert(0, "0");
            }
            string3 = stringBuffer.toString();
        }
        if ((n2 = 1900 + Integer.parseInt(string3.substring(0, 3))) < 1980 && !bl) {
            n2 += 100;
        }
        gregorianCalendar.set(1, n2);
        int n3 = Integer.parseInt(string3.substring(3, 5));
        gregorianCalendar.set(2, n3 - 1);
        int n4 = Integer.parseInt(string3.substring(5, 7));
        gregorianCalendar.set(5, n4);
        if (string4 == null || string4.length() == 0) {
            string4 = "000000";
        }
        if (n == 0) {
            string4 = string4 + "00";
        }
        if (string4.length() == 1) {
            string4 = "00000" + string4;
        }
        if (string4.length() == 2) {
            string4 = "0000" + string4;
        }
        if (string4.length() == 3) {
            string4 = "000" + string4;
        }
        if (string4.length() == 4) {
            string4 = "00" + string4;
        }
        if (string4.length() == 5) {
            string4 = "0" + string4;
        }
        int n5 = Integer.parseInt(string4.substring(0, 2));
        gregorianCalendar.set(10, n5);
        int n6 = Integer.parseInt(string4.substring(2, 4));
        gregorianCalendar.set(12, n6);
        int n7 = Integer.parseInt(string4.substring(4, 6));
        gregorianCalendar.set(13, n7);
        LocalizedDate localizedDate = new LocalizedDate(gregorianCalendar.getTime());
        LocalizedDate.correctTime(localizedDate);
        return localizedDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doFormat(DateFormat dateFormat, Date date, TimeZone timeZone) {
        Object object = changeLock;
        synchronized (object) {
            TimeZone timeZone2 = null;
            if (timeZone != null) {
                timeZone2 = dateFormat.getTimeZone();
                dateFormat.setTimeZone(timeZone);
            }
            String string = dateFormat.format(date);
            if (timeZone2 != null) {
                dateFormat.setTimeZone(timeZone2);
            }
            return string;
        }
    }

    public static Date parseTime(String string) throws ParseException {
        return DateTranslator.parseTime(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseTime(String string, TimeZone timeZone) throws ParseException {
        String string2 = string;
        if (string2 != null) {
            string2 = string2.trim();
        }
        ValidationHelper.checkForNullAndBlank("Time", string2);
        Object object = changeLock;
        synchronized (object) {
            String string3 = Character.toString(timeSeparator);
            if (timeSeparator == '.') {
                string3 = "\\.";
            }
            String[] stringArray = string2.split(string3);
            int n = DateTranslator.parsePiece(stringArray[0], "hour", 23);
            int n2 = 0;
            if (stringArray.length > 1) {
                n2 = DateTranslator.parsePiece(stringArray[1], "minute", 59);
            }
            int n3 = 0;
            if (stringArray.length > 2) {
                n3 = DateTranslator.parsePiece(stringArray[2], "second", 59);
            }
            String string4 = Integer.toString(n) + timeSeparator + n2 + timeSeparator + n3;
            TimeZone timeZone2 = null;
            if (timeZone != null) {
                timeZone2 = timeFormatHHMMSS.getTimeZone();
                timeFormatHHMMSS.setTimeZone(timeZone);
            }
            Date date = timeFormatHHMMSS.parse(string4);
            if (timeZone2 != null) {
                timeFormatHHMMSS.setTimeZone(timeZone2);
            }
            return date;
        }
    }

    private static int parsePiece(String string, String string2, int n) throws ParseException {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Invalid value, " + string2 + " = " + string, 0);
        }
        if (n2 < 0 || n2 > n) {
            throw new ParseException("Invalid value, " + string2 + " = " + string, 0);
        }
        return n2;
    }

    public static Date parseDate(String string) throws ParseException {
        return DateTranslator.parseDate(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDate(String string, TimeZone timeZone) throws ParseException {
        String string2 = string;
        if (string2 != null) {
            string2 = string2.trim();
        }
        ValidationHelper.checkForNullAndBlank("Date", string2);
        Object object = changeLock;
        synchronized (object) {
            Object object2;
            Object object3;
            String[] stringArray;
            String string3 = Character.toString(dateSeparator);
            if (dateSeparator == '.') {
                string3 = "\\.";
            }
            if ((stringArray = string2.split(string3)).length < 3) {
                object3 = new String[3];
                System.arraycopy(stringArray, 0, object3, 0, stringArray.length);
                stringArray = object3;
            }
            object3 = new StringBuffer();
            block8: for (int i = 0; i < stringArray.length; ++i) {
                object2 = stringArray[i];
                switch (datePattern) {
                    case 2: {
                        if (i == 0) {
                            ((StringBuffer)object3).append(DateTranslator.parseYear((String)object2));
                            ((StringBuffer)object3).append(dateSeparator);
                            continue block8;
                        }
                        if (i == 1) {
                            ((StringBuffer)object3).append(DateTranslator.parseMonth((String)object2));
                            ((StringBuffer)object3).append(dateSeparator);
                            continue block8;
                        }
                        if (i != 2) continue block8;
                        ((StringBuffer)object3).append(DateTranslator.parseDay((String)object2));
                        continue block8;
                    }
                    case 1: {
                        if (i == 0) {
                            ((StringBuffer)object3).append(DateTranslator.parseDay((String)object2));
                            ((StringBuffer)object3).append(dateSeparator);
                            continue block8;
                        }
                        if (i == 1) {
                            ((StringBuffer)object3).append(DateTranslator.parseMonth((String)object2));
                            ((StringBuffer)object3).append(dateSeparator);
                            continue block8;
                        }
                        if (i != 2) continue block8;
                        ((StringBuffer)object3).append(DateTranslator.parseYear((String)object2));
                        continue block8;
                    }
                    case 0: {
                        if (i == 0) {
                            ((StringBuffer)object3).append(DateTranslator.parseMonth((String)object2));
                            ((StringBuffer)object3).append(dateSeparator);
                            continue block8;
                        }
                        if (i == 1) {
                            ((StringBuffer)object3).append(DateTranslator.parseDay((String)object2));
                            ((StringBuffer)object3).append(dateSeparator);
                            continue block8;
                        }
                        if (i != 2) continue block8;
                        ((StringBuffer)object3).append(DateTranslator.parseYear((String)object2));
                        continue block8;
                    }
                    default: {
                        throw new IllegalStateException("Unable to determine  the current date pattern.");
                    }
                }
            }
            TimeZone timeZone2 = null;
            if (timeZone != null) {
                timeZone2 = dateFormatYYYY.getTimeZone();
                dateFormatYYYY.setTimeZone(timeZone);
            }
            object2 = dateFormatYYYY.parse(((StringBuffer)object3).toString());
            if (timeZone2 != null) {
                dateFormatYYYY.setTimeZone(timeZone2);
            }
            return object2;
        }
    }

    public static Date parseDateNoDay(String string) throws ParseException {
        return DateTranslator.parseDateNoDay(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateNoDay(String string, TimeZone timeZone) throws ParseException {
        String string2 = string;
        Object object = changeLock;
        synchronized (object) {
            int n = string2.indexOf(dateSeparator);
            if (n < 0) {
                throw new ParseException("Unable to find date separator " + dateSeparator + " in date " + string2, 0);
            }
            if (n == 0 || n == string2.length() - 1) {
                throw new ParseException("Invalid date format: " + string2, 0);
            }
            switch (datePattern) {
                case 2: {
                    string2 = string2 + dateSeparator + "01";
                    break;
                }
                case 0: {
                    String string3 = string2.substring(0, n + 1);
                    String string4 = string2.substring(n + 1);
                    string2 = string3 + "01" + dateSeparator + string4;
                    break;
                }
                case 1: {
                    string2 = "01" + dateSeparator + string2;
                }
            }
            return DateTranslator.parseDate(string2, timeZone);
        }
    }

    private static int parseYear(String string) throws ParseException {
        if (string == null || string.length() == 0) {
            return 0;
        }
        int n = DateTranslator.parsePiece(string, YEAR_LABEL, 9999);
        if (n < 100) {
            n = n < 70 ? (n += 2000) : (n += 1900);
        }
        return n;
    }

    private static int parseMonth(String string) throws ParseException {
        if (string == null || string.length() == 0) {
            return 1;
        }
        int n = DateTranslator.parsePiece(string, MONTH_LABEL, 12);
        if (n < 1) {
            throw new ParseException("Invalid value, Month = 0", 0);
        }
        return n;
    }

    private static int parseDay(String string) throws ParseException {
        if (string == null || string.length() == 0) {
            return 1;
        }
        int n = DateTranslator.parsePiece(string, DAY_LABEL, 31);
        if (n < 1) {
            throw new ParseException("Invalid value, Day = 0", 0);
        }
        return n;
    }

    public static String formatDate(Date date) {
        return DateTranslator.formatDate(date, null);
    }

    public static String formatDate(Date date, TimeZone timeZone) {
        return DateTranslator.doFormat(dateFormatYYYY, date, timeZone);
    }

    public static String formatShortDate(Date date) {
        return DateTranslator.formatShortDate(date, null);
    }

    public static String formatShortDate(Date date, TimeZone timeZone) {
        return DateTranslator.doFormat(dateFormatYY, date, timeZone);
    }

    public static String formatDateNoYear(Date date) {
        return DateTranslator.formatDateNoYear(date, null);
    }

    public static String formatDateNoYear(Date date, TimeZone timeZone) {
        return DateTranslator.doFormat(dateFormatNoYear, date, timeZone);
    }

    public static String formatDateNoDay(Date date) {
        return DateTranslator.formatDateNoDay(date, null);
    }

    public static String formatDateNoDay(Date date, TimeZone timeZone) {
        return DateTranslator.doFormat(dateFormatNoDay, date, timeZone);
    }

    public static String formatTime(Date date) {
        return DateTranslator.formatTime(date, null);
    }

    public static String formatTime(Date date, TimeZone timeZone) {
        return DateTranslator.doFormat(timeFormatHHMMSS, date, timeZone);
    }

    public static String formatShortTime(Date date) {
        return DateTranslator.formatShortTime(date, null);
    }

    public static String formatShortTime(Date date, TimeZone timeZone) {
        return DateTranslator.doFormat(timeFormatHHMM, date, timeZone);
    }

    public static String formatDateTime(Date date) {
        return DateTranslator.formatDateTime(date, null);
    }

    public static String formatDateTime(Date date, TimeZone timeZone) {
        return DateTranslator.formatDate(date, timeZone) + " " + DateTranslator.formatTime(date, timeZone);
    }

    public static String formatDateTimeWithTZ(Date date) {
        return DateTranslator.formatDateTime(date, null) + " " + TZ_FORMAT.format(date);
    }

    public static String formatDateTimeWithMillis(Date date) {
        return DateTranslator.formatDateTimeWithMillis(date, null);
    }

    public static String formatDateTimeWithMillis(Date date, TimeZone timeZone) {
        return DateTranslator.formatDate(date, timeZone) + " " + DateTranslator.doFormat(timeFormatHHMMSSms, date, timeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setFormatting(int n, char c, char c2) {
        Object object = changeLock;
        synchronized (object) {
            String string = "MDY";
            switch (n) {
                case 0: {
                    string = "MDY";
                    break;
                }
                case 2: {
                    string = "YMD";
                    break;
                }
                case 1: {
                    string = "DMY";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invald date pattern: " + n);
                }
            }
            datePattern = n;
            dateSeparator = c;
            timeSeparator = c2;
            String string2 = string.replaceAll("D", "");
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.insert(1, stringBuffer.charAt(0));
            stringBuffer.insert(2, c);
            stringBuffer.insert(4, stringBuffer.charAt(3));
            string2 = stringBuffer.toString().replaceAll("Y", "yy");
            dateFormatNoDay = new SimpleDateFormat(string2);
            String string3 = string.replaceAll("Y", "");
            stringBuffer = new StringBuffer(string3);
            stringBuffer.insert(1, stringBuffer.charAt(0));
            stringBuffer.insert(2, c);
            stringBuffer.insert(4, stringBuffer.charAt(3));
            string3 = stringBuffer.toString().replaceAll("D", "d");
            dateFormatNoYear = new SimpleDateFormat(string3);
            stringBuffer = new StringBuffer(string);
            stringBuffer.insert(1, stringBuffer.charAt(0));
            stringBuffer.insert(2, c);
            stringBuffer.insert(4, stringBuffer.charAt(3));
            stringBuffer.insert(5, c);
            stringBuffer.append(stringBuffer.charAt(6));
            string = stringBuffer.toString().replaceAll("Y", "y").replaceAll("D", "d");
            dateFormatYY = new SimpleDateFormat(string);
            string = string.replaceAll("yy", "yyyy");
            dateFormatYYYY = new SimpleDateFormat(string);
            String string4 = "HH" + c2 + "mm";
            timeFormatHHMM = new SimpleDateFormat(string4);
            string4 = string4 + c2 + "ss";
            timeFormatHHMMSS = new SimpleDateFormat(string4);
            timeFormatHHMMSSms = new SimpleDateFormat(string4 + ".SSS");
            if (configManager != null) {
                configManager.setProperty(DATE_FORMAT_INDEX, Integer.toString(DateTranslator.getDateFormat()));
                configManager.setProperty(DATE_SEPARATOR, Character.toString(DateTranslator.getDateSeparator()));
                configManager.setProperty(TIME_SEPARATOR, Character.toString(DateTranslator.getTimeSeparator()));
            }
        }
    }

    public static int getDateFormat() {
        return datePattern;
    }

    public static char getTimeSeparator() {
        return timeSeparator;
    }

    public static char getDateSeparator() {
        return dateSeparator;
    }

    public static void setConfigManager(IApplicationConfigManager iApplicationConfigManager) {
        if (iApplicationConfigManager == configManager) {
            return;
        }
        if (iApplicationConfigManager == null) {
            configManager = null;
            return;
        }
        int n = datePattern;
        char c = dateSeparator;
        char c2 = timeSeparator;
        String string = iApplicationConfigManager.getProperty(DATE_FORMAT_INDEX);
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((string = iApplicationConfigManager.getProperty(DATE_SEPARATOR)) != null && string.length() > 0) {
            c = string.charAt(0);
        }
        if ((string = iApplicationConfigManager.getProperty(TIME_SEPARATOR)) != null && string.length() > 0) {
            c2 = string.charAt(0);
        }
        DateTranslator.setFormatting(n, c, c2);
        configManager = iApplicationConfigManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatElapsedTime(long l) {
        boolean bl = l < 0L;
        long l2 = Math.abs(l) / 1000L;
        long l3 = l2 / 60L;
        long l4 = l3 / 60L;
        long l5 = l4 / 24L;
        int n = (int)(l2 % 60L);
        int n2 = (int)(l3 % 60L);
        int n3 = (int)(l4 % 24L);
        int n4 = (int)l5;
        StringBuffer stringBuffer = new StringBuffer();
        Object object = changeLock;
        synchronized (object) {
            if (bl) {
                stringBuffer.append("- ");
            }
            if (n4 > 0) {
                stringBuffer.append(n4);
                if (n4 == 1) {
                    stringBuffer.append(" day ");
                } else {
                    stringBuffer.append(" days ");
                }
            }
            if (n4 > 0 || n3 > 0) {
                if (n3 < 10) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(n3);
                stringBuffer.append(timeSeparator);
            }
            if (n2 < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n2);
            stringBuffer.append(timeSeparator);
            if (n < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }

    public static long getDaysOldAsMilliseconds(long l) {
        long l2 = 86400000L * l;
        return System.currentTimeMillis() - l2;
    }

    private static String getFullString(int n) {
        if (n >= 10) {
            return Integer.toString(n);
        }
        StringBuffer stringBuffer = new StringBuffer("0");
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public static BigDecimal getBigDecimalFromDate(long l) {
        BigDecimal bigDecimal = null;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.clear();
        gregorianCalendar.setTimeInMillis(l);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(gregorianCalendar.get(1));
        stringBuffer.append(DateTranslator.getFullString(gregorianCalendar.get(2) + 1));
        stringBuffer.append(DateTranslator.getFullString(gregorianCalendar.get(5)));
        stringBuffer.append(DateTranslator.getFullString(gregorianCalendar.get(11)));
        stringBuffer.append(DateTranslator.getFullString(gregorianCalendar.get(12)));
        stringBuffer.append(DateTranslator.getFullString(gregorianCalendar.get(13)));
        bigDecimal = new BigDecimal(stringBuffer.toString());
        return bigDecimal;
    }

    public static Date getDateFromBigDecimal(BigDecimal bigDecimal) {
        int n;
        Object object;
        String string = "1970";
        String string2 = "01";
        String string3 = "01";
        String string4 = "00";
        String string5 = "00";
        String string6 = "00";
        if (bigDecimal != null && bigDecimal.longValue() > 0L) {
            object = bigDecimal.toPlainString();
            n = ((String)object).length();
            if (n >= 4) {
                string = ((String)object).substring(0, 4);
            }
            if (n >= 6) {
                string2 = ((String)object).substring(4, 6);
            }
            if (n >= 8) {
                string3 = ((String)object).substring(6, 8);
            }
            if (n >= 10) {
                string4 = ((String)object).substring(8, 10);
            }
            if (n >= 12) {
                string5 = ((String)object).substring(10, 12);
            }
            if (n >= 14) {
                string6 = ((String)object).substring(12, 14);
            }
        }
        object = new GregorianCalendar();
        ((Calendar)object).clear();
        n = Integer.parseInt(string);
        ((Calendar)object).set(1, n);
        int n2 = Integer.parseInt(string2);
        ((Calendar)object).set(2, n2 - 1);
        int n3 = Integer.parseInt(string3);
        ((Calendar)object).set(5, n3);
        int n4 = Integer.parseInt(string4);
        ((Calendar)object).set(10, n4);
        int n5 = Integer.parseInt(string5);
        ((Calendar)object).set(12, n5);
        int n6 = Integer.parseInt(string6);
        ((Calendar)object).set(13, n6);
        LocalizedDate localizedDate = new LocalizedDate(((Calendar)object).getTime());
        LocalizedDate.correctTime(localizedDate);
        return localizedDate;
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        DateTranslator.setFormatting(1, '.', '.');
        Date date = null;
        date = stringArray.length > 0 ? DateTranslator.parseDate(stringArray[0]) : new Date();
        for (n = 0; n < 3; ++n) {
            DateTranslator.setFormatting(n, '-', ',');
            System.out.println(DateTranslator.formatDate(date));
            System.out.println(DateTranslator.formatShortDate(date));
            System.out.println(DateTranslator.formatDateNoYear(date));
            System.out.println(DateTranslator.formatDateNoDay(date));
            System.out.println(DateTranslator.formatTime(date));
            System.out.println();
        }
        System.out.println("Testing getDaysOldAsMilliseconds()");
        for (n = 365; n > 0; --n) {
            System.out.println("Days old number: " + n + " Date: " + new Date(DateTranslator.getDaysOldAsMilliseconds(n)));
        }
        BigDecimal bigDecimal = new BigDecimal(20120501111523L);
        System.out.println("BigDecimal times...");
        System.out.println("Plain String: " + bigDecimal.toPlainString());
        System.out.println("Converted: " + DateTranslator.getDateFromBigDecimal(bigDecimal));
        long l = System.currentTimeMillis();
        System.out.println("Now is: " + new Date(l));
        BigDecimal bigDecimal2 = DateTranslator.getBigDecimalFromDate(l);
        System.out.println("Big D: " + bigDecimal2);
        System.out.println("Resolved back: " + DateTranslator.getDateFromBigDecimal(bigDecimal2));
        System.out.println("Should be Inception: " + DateTranslator.getDateFromBigDecimal(null));
        System.out.println("When I was born: " + DateTranslator.getDateFromBigDecimal(new BigDecimal(19620928081532L)));
        System.out.println("End of Myan calendar date only: " + DateTranslator.getDateFromBigDecimal(new BigDecimal(20121221L)));
    }

    static {
        char c;
        TZ_FORMAT = new SimpleDateFormat("z");
        StringBuilder stringBuilder = new StringBuilder(20);
        String string = "M/DY";
        try {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3);
            string = simpleDateFormat.toPattern();
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                c = Character.toUpperCase(c);
                if (stringBuilder.length() == 0) {
                    stringBuilder.append(c);
                    continue;
                }
                if (stringBuilder.charAt(stringBuilder.length() - 1) == c) continue;
                stringBuilder.append(c);
                continue;
            }
            if (dateSeparator != '\u0000') continue;
            dateSeparator = c;
        }
        if (dateSeparator == '\u0000') {
            dateSeparator = (char)47;
        }
        if ("MDY".equals(string = stringBuilder.toString())) {
            datePattern = 0;
        } else if ("DMY".equals(string)) {
            datePattern = 1;
        } else if ("MDY".equals(string)) {
            datePattern = 0;
        }
        try {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getTimeInstance(3);
            string = simpleDateFormat.toPattern();
        }
        catch (MissingResourceException missingResourceException) {
            string = "";
        }
        timeSeparator = (char)58;
        for (int i = 0; i < string.length(); ++i) {
            c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            timeSeparator = c;
            break;
        }
        changeLock = new Object();
        DateTranslator.setFormatting(datePattern, dateSeparator, timeSeparator);
    }
}

