/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.schedule;

import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.util.ValidationHelper;

public class CommonScheduleJob
extends Proxy {
    private static final long serialVersionUID = -7561574339086124270L;
    private String type = "";
    private String jobNumber = "";
    private String notes = "";
    private String jobD = "*RBTDFT";
    private String jobDLib = "*RBTDFT";
    private String outQ = "*RBTDFT";
    private String outQLib = "*RBTDFT";
    private int[] runTimes = new int[8];
    private char[] runDays = new char[7];
    private String[] commandStr = new String[1];
    private String application = "";
    private boolean persistent = false;
    private String scheduleJobApplicationName = "";

    public CommonScheduleJob() {
        this.commandStr[0] = "";
    }

    public String getJobType() {
        return this.type;
    }

    public void setJobType(String string) {
        ValidationHelper.checkForNull("Job Type", string);
        this.type = string.trim();
    }

    public void setJobName(String string) {
        this.setName(string);
    }

    @Override
    public void setName(String string) {
        ValidationHelper.checkForNull("Job Name", string);
        super.setName(string.toUpperCase().trim());
    }

    public String getJobName() {
        return this.getName();
    }

    @Override
    public void setDescription(String string) {
        ValidationHelper.checkForNull("Description", string);
        super.setDescription(string.trim());
    }

    public void setNotes(String string) {
        ValidationHelper.checkForNull("Notes", string);
        this.notes = string;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setJobD(String string) {
        ValidationHelper.checkForNull("Job Description", string);
        this.jobD = string;
    }

    public String getJobD() {
        return this.jobD;
    }

    public void setJobDLib(String string) {
        ValidationHelper.checkForNull("Job Description Library", string);
        this.jobDLib = string;
    }

    public String getJobDLib() {
        return this.jobDLib;
    }

    public void setOutQ(String string) {
        ValidationHelper.checkForNull("Output Queue", string);
        this.outQ = string;
    }

    public String getOutQ() {
        return this.outQ;
    }

    public void setOutQLib(String string) {
        ValidationHelper.checkForNull("Output Queue Library", string);
        this.outQLib = string;
    }

    public String getOutQLib() {
        return this.outQLib;
    }

    public void setJobNumber(String string) {
        ValidationHelper.checkForNull("Job Number", string);
        this.jobNumber = string;
    }

    public String getJobNumber() {
        return this.jobNumber;
    }

    public void setCommandStr(String string) {
        ValidationHelper.checkForNull("Job Command", string);
        String[] stringArray = new String[]{string};
        this.commandStr = stringArray;
    }

    public void setCommandStr(String[] stringArray) {
        ValidationHelper.checkForNull("Job Command", stringArray);
        this.commandStr = stringArray;
    }

    public String[] getCommandStr() {
        return this.commandStr;
    }

    public void setApplication(String string) {
        ValidationHelper.checkForNull("Application", string);
        this.application = string;
    }

    public void setScheduleJobApplicationName(String string) {
        ValidationHelper.checkForNull("Application Name", this.scheduleJobApplicationName);
        this.scheduleJobApplicationName = string;
    }

    public String getApplication() {
        return this.application;
    }

    public String getScheduleJobApplicationName() {
        return this.scheduleJobApplicationName;
    }

    public void setRunTimes(int[] nArray) {
        ValidationHelper.checkForNull("Run Times array", nArray);
        if (nArray.length != this.runTimes.length) {
            throw new IllegalArgumentException("Run Times array has " + nArray.length + " elements when " + this.runTimes.length + " are required.");
        }
        for (int i = 0; i < this.runTimes.length; ++i) {
            this.runTimes[i] = nArray[i];
        }
    }

    public int[] getRunTimes() {
        return this.runTimes;
    }

    public void setRunDays(char[] cArray) {
        ValidationHelper.checkForNull("Run Days array", cArray);
        if (cArray.length != this.runDays.length) {
            throw new IllegalArgumentException("Run Days array has " + cArray.length + " elements when " + this.runDays.length + " are required.");
        }
        for (int i = 0; i < this.runDays.length; ++i) {
            this.runDays[i] = cArray[i];
        }
    }

    public char[] getRunDays() {
        return this.runDays;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean bl) {
        this.persistent = bl;
    }

    private void validateCommands(String string, String[] stringArray, int n, int n2, int n3) {
        ValidationHelper.checkForNull(string, stringArray);
        if (stringArray.length < n) {
            throw new IllegalArgumentException(string + " has too few elements.  Minimum " + n + " required.");
        }
        if (stringArray.length > n2) {
            throw new IllegalArgumentException(string + " has too many elements.  Maximum " + n2 + " required.");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            ValidationHelper.checkForNull(string + " string number " + i, stringArray[i]);
            if (stringArray[i].trim().length() <= n3) continue;
            throw new IllegalArgumentException(string + " exceeds maximum length of " + n3 + ".");
        }
    }

    private void validateLength(String string, String string2, int n) {
        if (string2.length() > n) {
            throw new IllegalArgumentException(string + " exceeds maximum length of " + n + ".");
        }
    }

    private void validateRequired(String string, String string2) {
        if (string2.length() == 0) {
            throw new IllegalArgumentException(string + " must be specified.");
        }
    }

    public void validate() {
        String string = "Job Name";
        this.validateRequired(string, this.getJobName());
        this.TruncateJobDesc();
        string = "Job Notes";
        this.validateLength(string, this.getNotes(), 60);
        string = "Job Description";
        this.validateLength(string, this.getJobD(), 10);
        string = "Job Description Library";
        this.validateLength(string, this.getJobDLib(), 10);
        string = "Output Queue";
        this.validateLength(string, this.getOutQ(), 10);
        string = "Output Queue Library";
        this.validateLength(string, this.getOutQLib(), 10);
        string = "Command String(s)";
        this.validateCommands(string, this.getCommandStr(), 1, 10, 3000);
        string = "Application";
        this.validateLength(string, this.getApplication(), 3);
        String string2 = this.getJobType();
        if (!(string2.equals("C") || string2.equals("G") || string2.equals("P"))) {
            throw new IllegalArgumentException("Invalid Job Type: " + string2);
        }
    }

    private void TruncateJobDesc() {
        if (this.getDescription().length() > 25) {
            this.setDescription(this.getDescription().substring(0, 24));
        }
    }
}

