/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.opal;

import com.helpsystems.common.core.opal.OpalErrorsException;
import com.helpsystems.common.core.opal.OpalExceptions;
import com.helpsystems.common.core.opal.OpalWarningsException;
import java.util.Hashtable;
import junit.framework.TestCase;

public class OpalExceptionsTest
extends TestCase {
    Throwable t;
    OpalErrorsException oee;
    OpalWarningsException owe;
    OpalExceptions oe;

    protected void setUp() throws Exception {
        super.setUp();
        this.t = new Throwable();
        this.oee = new OpalErrorsException("opal_errors_message");
        this.owe = new OpalWarningsException("opal_warnings_message");
        this.oe = new OpalExceptions();
        this.oee.addException("message", 0);
        this.owe.addException("message", 0);
    }

    protected void tearDown() throws Exception {
        this.oe = null;
        this.oee = null;
        this.owe = null;
        this.t = null;
        super.tearDown();
    }

    public void testContainsOpalErrors() {
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsOpalErrors());
        this.oe.setOpalErrors(this.oee);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsOpalErrors());
    }

    public void testContainsOpalWarnings() {
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsOpalWarnings());
        this.oe.setOpalWarnings(this.owe);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsOpalWarnings());
    }

    public void testContainsReplyOpalErrors() {
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsReplyOpalErrors());
        this.oe.setReplyOpalErrors(this.oee);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsReplyOpalErrors());
    }

    public void testContainsReplyOpalWarnings() {
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsReplyOpalWarnings());
        this.oe.setReplyOpalWarnings(this.owe);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsReplyOpalWarnings());
    }

    public void testOpalExceptionsOpalErrorsExceptionOpalWarningsException() {
        this.oe = new OpalExceptions(this.oee, this.owe);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsOpalErrors());
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsOpalWarnings());
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsReplyOpalErrors());
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsReplyOpalWarnings());
    }

    public void testOpalExceptionsOpalErrorsException() {
        this.oe = new OpalExceptions(this.oee);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsOpalErrors());
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsOpalWarnings());
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsReplyOpalErrors());
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsReplyOpalWarnings());
    }

    public void testOpalExceptionsOpalWarningsException() {
        this.oe = new OpalExceptions(this.owe);
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsOpalErrors());
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsOpalWarnings());
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsReplyOpalErrors());
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsReplyOpalWarnings());
    }

    public void testSetOpalErrors() {
        this.oe.setOpalErrors(this.oee);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsOpalErrors());
        OpalExceptionsTest.assertEquals((Object)this.oee, (Object)this.oe.getOpalErrors());
    }

    public void testSetOpalWarnings() {
        this.oe.setOpalWarnings(this.owe);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsOpalWarnings());
        OpalExceptionsTest.assertEquals((Object)this.owe, (Object)this.oe.getOpalWarnings());
    }

    public void testSetReplyOpalErrors() {
        this.oe.setReplyOpalErrors(this.oee);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsReplyOpalErrors());
        OpalExceptionsTest.assertEquals((Object)this.oee, (Object)this.oe.getReplyOpalErrors());
    }

    public void testSetReplyOpalWarnings() {
        this.oe.setReplyOpalWarnings(this.owe);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsReplyOpalWarnings());
        OpalExceptionsTest.assertEquals((Object)this.owe, (Object)this.oe.getReplyOpalWarnings());
    }

    public void testContainsAnyExceptions() {
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsAnyExceptions());
        this.oe.setReplyOpalWarnings(this.owe);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsAnyExceptions());
        this.oe.setReplyOpalWarnings(null);
        this.oe.setOpalWarnings(this.owe);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsAnyExceptions());
        this.oe.setOpalWarnings(null);
        this.oe.setReplyOpalErrors(this.oee);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsAnyExceptions());
        this.oe.setReplyOpalErrors(null);
        this.oe.setOpalErrors(this.oee);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsAnyExceptions());
    }

    public void testContainsAnyErrors() {
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsAnyErrors());
        this.oe.setReplyOpalWarnings(this.owe);
        this.oe.setOpalWarnings(this.owe);
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsAnyErrors());
        this.oe.setReplyOpalErrors(this.oee);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsAnyErrors());
        this.oe.setReplyOpalErrors(null);
        this.oe.setOpalErrors(this.oee);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsAnyErrors());
    }

    public void testContainsLogicErrors() {
        OpalExceptionsTest.assertFalse((boolean)this.oe.containsLogicErrors());
        this.oe.setContainsLogicErrors(true);
        OpalExceptionsTest.assertTrue((boolean)this.oe.containsLogicErrors());
    }

    public void testAbstractOpalExpressionMethods() {
        this.oee = new OpalErrorsException("errors_exception");
        OpalExceptionsTest.assertEquals((int)-1, (int)this.oee.getMaxIndex());
        this.oee.addException("message", 0);
        OpalExceptionsTest.assertEquals((int)0, (int)this.oee.getMaxIndex());
        OpalExceptionsTest.assertEquals((int)1, (int)this.oee.getMessageCount());
        OpalExceptionsTest.assertEquals((String)"message", (String)this.oee.getMessageTextForIndex(0));
        OpalExceptionsTest.assertNull((Object)this.oee.getMessageTextForIndex(1));
        this.oee.addException("message1a", 1);
        this.oee.addException("message1b", 1);
        String string = "message1a\nmessage1b";
        OpalExceptionsTest.assertEquals((String)string, (String)this.oee.getMessageTextForIndex(1));
        Hashtable hashtable = this.oee.getAllMessages();
        OpalExceptionsTest.assertEquals((int)2, (int)hashtable.size());
        OpalExceptionsTest.assertTrue((boolean)hashtable.containsKey(0));
        OpalExceptionsTest.assertEquals((Object)"message", hashtable.get(0));
        OpalExceptionsTest.assertTrue((boolean)hashtable.containsKey(1));
        OpalExceptionsTest.assertEquals((Object)string, hashtable.get(1));
    }
}

