/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.network;

import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.Identifiable;
import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.network.SystemIID;
import com.helpsystems.common.core.util.Equal;

public class SystemProxy
extends Proxy
implements Identifiable {
    private static final long serialVersionUID = 7679361646047026747L;
    public static final int TIME_ZONE_DEFAULT = 0;
    private String address;
    private int timeZone;
    private String hardwareKey;

    public String getAddress() {
        return this.address;
    }

    public String getHardwareKey() {
        return this.hardwareKey;
    }

    public int getTimeZone() {
        return this.timeZone;
    }

    public int getSystemIID() {
        BasicIdentifier basicIdentifier = this.getIdentifier();
        if (basicIdentifier != null && basicIdentifier instanceof SystemIID) {
            return ((SystemIID)basicIdentifier).getID();
        }
        return 0;
    }

    public int hashCode() {
        return this.getSystemIID() * 83;
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public void setSystemIID(int n) {
        this.setIdentifier(new SystemIID(n));
    }

    public void setTimeZone(int n) {
        this.timeZone = n;
    }

    public void setHardwareKey(String string) {
        this.hardwareKey = string;
    }

    @Override
    public void setIdentifier(BasicIdentifier basicIdentifier) {
        if (basicIdentifier == null || !(basicIdentifier instanceof SystemIID)) {
            throw new IllegalArgumentException("The identifier " + basicIdentifier + " is not valid - it must be a SystemIID");
        }
        super.setIdentifier(basicIdentifier);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof SystemProxy)) {
            return false;
        }
        SystemProxy systemProxy = (SystemProxy)object;
        return super.equals(object) && Equal.isEqual(systemProxy.address, this.address) && Equal.isEqual(systemProxy.hardwareKey, this.hardwareKey) && Equal.isEqual(systemProxy.timeZone, this.timeZone);
    }
}

