/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.network;

import com.helpsystems.common.core.network.PacketElementProxy;
import com.helpsystems.common.core.util.Equal;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;

public class PacketElement
extends PacketElementProxy {
    private static final long serialVersionUID = 9197287197313628960L;
    private byte[] payload;
    private byte[] properties;

    public void setPayloadByteArray(byte[] byArray) {
        this.payload = byArray;
    }

    public void setPayload(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.close();
        byteArrayOutputStream.close();
        this.payload = byteArrayOutputStream.toByteArray();
    }

    public void setPropertiesByteArray(byte[] byArray) {
        this.properties = byArray;
    }

    public void setProperties(Properties properties) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(properties);
        objectOutputStream.close();
        byteArrayOutputStream.close();
        this.properties = byteArrayOutputStream.toByteArray();
    }

    public byte[] getPayloadByteArray() {
        return this.payload;
    }

    public Serializable getPayload() throws IOException, ClassNotFoundException {
        Serializable serializable = null;
        if (this.payload != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.payload);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            serializable = (Serializable)objectInputStream.readObject();
            objectInputStream.close();
            byteArrayInputStream.close();
        }
        return serializable;
    }

    public byte[] getPropertiesByteArray() {
        return this.properties;
    }

    public Properties getProperties() throws IOException, ClassNotFoundException {
        Properties properties = null;
        if (this.properties != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.properties);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            properties = (Properties)objectInputStream.readObject();
            objectInputStream.close();
            byteArrayInputStream.close();
        }
        return properties;
    }

    public void setPacketElementOID(int n) {
        this.setObjectIDInt(n);
    }

    public boolean isEqual(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        PacketElement packetElement = (PacketElement)object;
        return super.equals(object) && Equal.isEqual(this.payload, packetElement.payload);
    }
}

