/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.network;

import com.helpsystems.common.core.network.AbstractBusinessObject;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.ValidationHelper;
import java.sql.Timestamp;

public class PacketDistributionHistory
extends AbstractBusinessObject {
    private static final long serialVersionUID = -4501089165878942698L;
    public static final int USER_MAX_LENGTH = 10;
    public static final int DESCRIPTION_MAX_LENGTH = 50;
    public static final int OCCURRENCE_CODE_CREATED = 2;
    public static final int OCCURRENCE_CODE_INSTALLED = 3;
    public static final int OCCURRENCE_CODE_REVERSED = 5;
    public static final int OCCURRENCE_CODE_DELETED = 7;
    private int packetDistributionOID;
    private String occurrenceDescription;
    private String occurrenceUser;
    private Timestamp occurrenceDateTime;

    public PacketDistributionHistory() {
    }

    public PacketDistributionHistory(int n, int n2, String string, String string2, Timestamp timestamp) {
        this.setObjectIDInt(n);
        this.setPacketDistributionOID(n2);
        this.setOccurrenceDescription(string);
        this.setOccurrenceUser(string2);
        this.setOccurrenceDateTime(timestamp);
    }

    public PacketDistributionHistory(int n, int n2, String string, String string2) {
        this(n, n2, string, string2, PacketDistributionHistory.getNowTime());
    }

    private static Timestamp getNowTime() {
        Timestamp timestamp = new Timestamp(0L);
        timestamp.setTime(System.currentTimeMillis());
        return timestamp;
    }

    public void setPacketDistributionOID(int n) {
        this.packetDistributionOID = n;
    }

    public int getPacketDistributionOID() {
        return this.packetDistributionOID;
    }

    public void setOccurrenceDescription(String string) {
        ValidationHelper.validateLength("Occurrence Description", 50, string);
        this.occurrenceDescription = string;
    }

    public String getOccurrenceDescription() {
        return this.occurrenceDescription;
    }

    public void setOccurrenceUser(String string) {
        ValidationHelper.validateLength("Occurrence User", 10, string);
        this.occurrenceUser = string;
    }

    public String getOccurrenceUser() {
        return this.occurrenceUser;
    }

    public void setOccurrenceDateTime(Timestamp timestamp) {
        this.occurrenceDateTime = timestamp;
    }

    public Timestamp getOccurrenceDateTime() {
        return this.occurrenceDateTime;
    }

    public int hashCode() {
        long l = this.occurrenceDateTime.getTime();
        int n = (int)(l ^ l >> 32);
        int n2 = 7;
        n2 = 11 * n2 + this.packetDistributionOID;
        n2 = 11 * n2 + this.occurrenceDescription.hashCode();
        n2 = 11 * n2 + this.occurrenceUser.hashCode();
        n2 = 11 * n2 + n;
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        PacketDistributionHistory packetDistributionHistory = (PacketDistributionHistory)object;
        return Equal.isEqual(this.packetDistributionOID, packetDistributionHistory.packetDistributionOID) && Equal.isEqual(this.occurrenceDescription, packetDistributionHistory.occurrenceDescription) && Equal.isEqual(this.occurrenceUser, packetDistributionHistory.occurrenceUser) && Equal.isEqual(this.occurrenceDateTime, packetDistributionHistory.occurrenceDateTime);
    }
}

