/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.license;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.dm.LicenseManagerDM;
import com.helpsystems.common.core.encryption.EncryptUtil;
import com.helpsystems.common.core.encryption.MD5;
import com.helpsystems.common.core.license.LicenseKey;
import com.helpsystems.common.core.util.ValidationHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class LicenseKeyManager
extends AbstractManager
implements LicenseManagerDM {
    private static final Logger logger = Logger.getLogger(LicenseKeyManager.class);
    private HashMap<String, ArrayList<LicenseKey>> table;
    private int licenseCount;
    private String filename;
    private EncryptUtil encryptUtil;

    private LicenseKeyManager() {
        this.setName("COMMON.LicenseManagerDM");
        this.table = new HashMap();
    }

    public LicenseKeyManager(String string, EncryptUtil encryptUtil) throws IOException {
        this();
        ValidationHelper.checkForNull("Filename", string);
        this.filename = string;
        ValidationHelper.checkForNull("EncryptUtil", encryptUtil);
        this.encryptUtil = encryptUtil;
        File file = new File(string);
        if (file.exists()) {
            this.load();
        }
    }

    @Override
    public void addLicense(LicenseKey licenseKey) throws ResourceUnavailableException {
        this.innerAddLicense(licenseKey);
        this.innerSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerAddLicense(LicenseKey licenseKey) {
        String string = licenseKey.getHardwareCode();
        HashMap<String, ArrayList<LicenseKey>> hashMap = this.table;
        synchronized (hashMap) {
            ArrayList<LicenseKey> arrayList = this.table.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.table.put(string, arrayList);
            } else {
                Iterator<LicenseKey> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    LicenseKey licenseKey2 = iterator.next();
                    if (!licenseKey.getProductCode().equals(licenseKey2.getProductCode())) continue;
                    iterator.remove();
                    --this.licenseCount;
                    break;
                }
            }
            arrayList.add(licenseKey);
            ++this.licenseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws ResourceUnavailableException {
        HashMap<String, ArrayList<LicenseKey>> hashMap = this.table;
        synchronized (hashMap) {
            this.table.clear();
            this.licenseCount = 0;
        }
        this.innerSave();
    }

    @Override
    public LicenseKey getLicenseForCode(String string, String string2) {
        return this.getLicense(string, string2);
    }

    @Override
    public LicenseKey getLicenseForIdentifier(String string, String string2) throws ResourceUnavailableException {
        try {
            return this.getLicense(MD5.hashText(string), string2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ResourceUnavailableException("Unable to perform MD5 function.", noSuchAlgorithmException);
        }
    }

    @Override
    public LicenseKey[] getLicensesForCode(String string) {
        return this.getLicensesForCode(string);
    }

    @Override
    public LicenseKey[] getLicensesForIdentifier(String string) throws ResourceUnavailableException {
        try {
            return this.getLicensesForCode(MD5.hashText(string));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ResourceUnavailableException("Unable to perform MD5 function.", noSuchAlgorithmException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenseKey getLicense(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException("The product code passed in is null.");
        }
        String string3 = string2.toUpperCase();
        if (string == null) {
            throw new NullPointerException("The hardware code passed in is null.");
        }
        ArrayList<LicenseKey> arrayList = null;
        HashMap<String, ArrayList<LicenseKey>> hashMap = this.table;
        synchronized (hashMap) {
            arrayList = this.table.get(string);
        }
        if (arrayList == null) {
            return null;
        }
        for (LicenseKey licenseKey : arrayList) {
            if (!licenseKey.getProductCode().equals(string3)) continue;
            return licenseKey;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenseKey[] getLicenses(String string) {
        if (string == null) {
            throw new NullPointerException("The hardware code passed in is null.");
        }
        ArrayList<LicenseKey> arrayList = null;
        LicenseKey[] licenseKeyArray = this.table;
        synchronized (this.table) {
            arrayList = this.table.get(string);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (arrayList == null) {
                return new LicenseKey[0];
            }
            licenseKeyArray = new LicenseKey[arrayList.size()];
            arrayList.toArray(licenseKeyArray);
            return licenseKeyArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        BufferedReader bufferedReader = null;
        int n = 0;
        try {
            FileReader fileReader = new FileReader(this.filename);
            bufferedReader = new BufferedReader(fileReader);
            while (true) {
                ++n;
                String string = bufferedReader.readLine();
                if (string == null) {
                    break;
                }
                if ((string = string.trim()).startsWith("#") || string.length() == 0) continue;
                LicenseKey licenseKey = null;
                try {
                    licenseKey = LicenseKey.createLicenseKey(string, this.encryptUtil);
                    this.innerAddLicense(licenseKey);
                }
                catch (IOException iOException) {
                    logger.warn((Object)("Invalid license key found in file " + this.filename + " at line " + n + ": " + string), (Throwable)iOException);
                }
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLicense(String string, String string2) throws ResourceUnavailableException {
        if (string2 == null) {
            throw new NullPointerException("The product code passed in is null.");
        }
        String string3 = string2.toUpperCase();
        if (string == null) {
            throw new NullPointerException("The hardware code passed in is null.");
        }
        HashMap<String, ArrayList<LicenseKey>> hashMap = this.table;
        synchronized (hashMap) {
            ArrayList<LicenseKey> arrayList = this.table.get(string);
            if (arrayList != null) {
                Iterator<LicenseKey> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    LicenseKey licenseKey = iterator.next();
                    if (!licenseKey.getProductCode().equals(string3)) continue;
                    iterator.remove();
                    return;
                }
            }
        }
        this.innerSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLicenses(String string) throws ResourceUnavailableException {
        if (string == null) {
            throw new NullPointerException("The hardware code passed in is null.");
        }
        HashMap<String, ArrayList<LicenseKey>> hashMap = this.table;
        synchronized (hashMap) {
            ArrayList<LicenseKey> arrayList = this.table.get(string);
            if (arrayList != null) {
                this.licenseCount -= arrayList.size();
                arrayList.clear();
                this.table.remove(string);
            }
        }
        this.innerSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() throws IOException {
        if (this.filename == null) {
            throw new IOException("Unable to save licenses, no file specified");
        }
        PrintWriter printWriter = null;
        try {
            FileWriter fileWriter = new FileWriter(this.filename);
            printWriter = new PrintWriter(fileWriter);
            printWriter.println("# This file contains the encrypted license keys for");
            printWriter.println("# Help/Systems Robot (TM) products.");
            printWriter.println("# Automatically updated at " + new Date());
            HashMap<String, ArrayList<LicenseKey>> hashMap = this.table;
            synchronized (hashMap) {
                for (ArrayList<LicenseKey> arrayList : this.table.values()) {
                    for (LicenseKey licenseKey : arrayList) {
                        printWriter.println(licenseKey.getEncryptedKey());
                    }
                }
            }
        }
        finally {
            try {
                printWriter.close();
            }
            catch (Exception exception) {}
        }
    }

    private void innerSave() throws ResourceUnavailableException {
        try {
            this.save();
        }
        catch (IOException iOException) {
            throw new ResourceUnavailableException("Unable to save licenses to file " + this.filename, iOException);
        }
    }

    public int size() {
        return this.licenseCount;
    }

    public static LicenseKeyManager getTemporaryInstance() {
        return new LicenseKeyManager();
    }
}

