/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.license;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.encryption.EncryptUtil;
import com.helpsystems.common.core.util.DateTranslator;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.XMLSerializable;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;

public class LicenseKey
extends CommonVersionedObject
implements XMLSerializable {
    private static final long serialVersionUID = -213207821777468154L;
    public static final int TRIAL_KEY = 0;
    public static final int PERM_KEY = 1;
    public static final int ELA_KEY = 2;
    static final String DEFAULT_ENCODING = "ISO8859_1";
    static final long DIVISOR = 10811194L;
    static final long TWELVE_HOURS = 43200000L;
    private long expirationDate;
    private String hardwareCode;
    private String productCode;
    private String encryptedLicense;
    protected int keyType;
    protected byte flags;

    public LicenseKey() {
    }

    public LicenseKey(String string, String string2, long l) {
        this.setProductCode(string);
        this.setHardwareCode(string2);
        this.setExpirationDate(l);
    }

    public static LicenseKey createLicenseKey(String string, EncryptUtil encryptUtil) throws IOException {
        LicenseKey licenseKey = new LicenseKey();
        licenseKey.setEncryptedKey(string, encryptUtil);
        return licenseKey;
    }

    @Override
    public String[] doNotInvoke() {
        return new String[]{"getExpirationDate", "getHardwareCode", "getProductCode"};
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public String getHardwareCode() {
        return this.hardwareCode;
    }

    public String getEncryptedKey() {
        return this.encryptedLicense;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public int getKeyType() {
        return this.keyType;
    }

    public void setKeyType(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Invalid type");
        }
        this.keyType = n;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void setFlags(byte by) {
        byte by2 = by;
        if (by2 < 0) {
            throw new IllegalArgumentException("Invalid value: " + Integer.toHexString(by));
        }
        this.flags = by;
    }

    public void isExpiredSampleCode() {
        LicenseKey licenseKey = null;
        TimeZone timeZone = TimeZone.getDefault();
        long l = licenseKey.getExpirationDate();
        long l2 = System.currentTimeMillis();
        long l3 = l + (long)timeZone.getOffset(l2) + 43200000L;
        long l4 = l2 + (long)timeZone.getOffset(l2);
        if (l <= 0L || l3 < l4) {
            // empty if block
        }
    }

    public void setEncryptedKey(String string, EncryptUtil encryptUtil) throws IOException {
        int n;
        if (encryptUtil == null) {
            throw new NullPointerException("The encryption utilities passed in were null.");
        }
        ValidationHelper.checkForNull("License", string);
        String string2 = EncryptUtil.cleanBeforeDecode(string);
        if (string2.length() == 55) {
            if (!LicenseKey.verifyChecksum(string2)) {
                throw new IOException("Checksum failed.");
            }
            string2 = string2.substring(0, 52);
        }
        byte[] byArray = null;
        try {
            byArray = encryptUtil.decodeBase32ToBinary(string2);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Unable to decode the license key");
            iOException.initCause(exception);
            throw iOException;
        }
        String string3 = new String(byArray, "UTF-8");
        StringBuffer stringBuffer = new StringBuffer(string3);
        for (int i = stringBuffer.length() - 1; i > -1; --i) {
            n = stringBuffer.charAt(i);
            if (n < 126) continue;
            stringBuffer.deleteCharAt(i);
        }
        if (stringBuffer.length() < 15) {
            throw new IOException("Decoded key length too small.");
        }
        string3 = stringBuffer.toString();
        this.setHardwareCode(string3.substring(0, 10));
        string3 = string3.substring(10);
        stringBuffer.delete(0, 10);
        StringBuffer stringBuffer2 = new StringBuffer();
        for (n = stringBuffer.length() - 1; n > -1; --n) {
            char c = stringBuffer.charAt(n);
            if (c < 'A' || c > 'Z') continue;
            stringBuffer2.append(c);
            stringBuffer.deleteCharAt(n);
        }
        this.setProductCode(stringBuffer2.reverse().toString());
        try {
            long l = Long.parseLong(stringBuffer.toString()) * 10811194L;
            if (l < 0L) {
                l = 0L;
            }
            this.setExpirationDate(l);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Bad data within encoded key.");
        }
        this.encryptedLicense = string2;
    }

    public void setExpirationDate(long l) {
        this.expirationDate = l / 10811194L * 10811194L;
    }

    public void setHardwareCode(String string) {
        if (string.length() != 10) {
            throw new IllegalArgumentException("The hardware code is invalid, it should be exactly 10 characters long.");
        }
        this.hardwareCode = string;
    }

    public void setProductCode(String string) {
        if (string == null) {
            this.productCode = null;
            return;
        }
        if (string.length() > 3) {
            throw new IllegalArgumentException("The product code '" + string + "' is invalid because it contains more than 3 letters.");
        }
        String string2 = string.toUpperCase();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c >= 'A' && c <= 'Z') continue;
            throw new IllegalArgumentException("The product code '" + string + "' is invalid. The character '" + c + "' is not allowed.");
        }
        this.productCode = string2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getProductCode());
        stringBuffer.append(' ');
        stringBuffer.append(this.getHardwareCode());
        stringBuffer.append(' ');
        long l = this.getExpirationDate();
        stringBuffer.append(DateTranslator.formatDateTime(new Date(l), TimeZone.getTimeZone("GMT")));
        return stringBuffer.toString();
    }

    public static boolean verifyChecksum(String string) {
        String string2 = EncryptUtil.cleanBeforeDecode(string);
        int n = string2.length() - 3;
        String string3 = string2.substring(n);
        string2 = string2.substring(0, n);
        String string4 = LicenseKey.generateChecksum(string2);
        return string4.equals(string3);
    }

    static String generateChecksum(String string) {
        ValidationHelper.checkForNullAndBlank("String", string);
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n += string.charAt(i);
        }
        String string2 = Integer.toString(n &= Short.MAX_VALUE, 32).toUpperCase();
        return EncryptUtil.cleanAfterEncode(string2);
    }
}

