/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.license;

import com.helpsystems.common.core.license.InvalidLicenseVersionException;
import java.util.HashMap;
import java.util.Map;

public enum AgentLicenseVersion {
    UNKNOWN(-1),
    NONE(0),
    ONE(1);

    private int integerCode;
    private static Map<Integer, AgentLicenseVersion> map;

    private AgentLicenseVersion(int n2) {
        this.integerCode = n2;
    }

    public static AgentLicenseVersion getVersion(int n) throws InvalidLicenseVersionException {
        AgentLicenseVersion agentLicenseVersion = map.get(n);
        if (agentLicenseVersion == null) {
            throw new InvalidLicenseVersionException("Version " + n + " is not a supported license key version.");
        }
        return agentLicenseVersion;
    }

    public static AgentLicenseVersion getLatest() {
        AgentLicenseVersion agentLicenseVersion = ONE;
        int n = -1;
        for (Integer n2 : map.keySet()) {
            if (n2 <= n) continue;
            n = n2;
        }
        try {
            agentLicenseVersion = AgentLicenseVersion.getVersion(n);
        }
        catch (InvalidLicenseVersionException invalidLicenseVersionException) {
            // empty catch block
        }
        return agentLicenseVersion;
    }

    static {
        map = new HashMap<Integer, AgentLicenseVersion>();
        for (AgentLicenseVersion agentLicenseVersion : AgentLicenseVersion.values()) {
            map.put(agentLicenseVersion.integerCode, agentLicenseVersion);
        }
    }
}

