/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.license;

import java.util.HashMap;
import java.util.Map;

public enum AgentLicenseTier {
    UNDEFINED(0, ' '),
    TIER_1(1, 'A'),
    TIER_2(2, 'B'),
    TIER_3(3, 'C'),
    TIER_4(4, 'D');

    private int integerCode;
    private char characterCode;
    private static Map<Integer, AgentLicenseTier> map;
    private static Map<Character, AgentLicenseTier> codeMap;

    private AgentLicenseTier(int n2, char c) {
        this.integerCode = n2;
        this.characterCode = c;
    }

    public Integer integerCode() {
        return this.integerCode;
    }

    public char characterCode() {
        return this.characterCode;
    }

    public static AgentLicenseTier getTier(int n) {
        AgentLicenseTier agentLicenseTier = map.get(n);
        if (agentLicenseTier == null) {
            return UNDEFINED;
        }
        return agentLicenseTier;
    }

    public static AgentLicenseTier getTier(char c) {
        return codeMap.get(Character.valueOf(c));
    }

    public static AgentLicenseTier getTier(int n, boolean bl) {
        AgentLicenseTier agentLicenseTier = AgentLicenseTier.getTier(n);
        if (bl) {
            agentLicenseTier = AgentLicenseTier.getTier(AgentLicenseTier.getNextHigherTier(n));
        }
        return agentLicenseTier;
    }

    private static int getNextHigherTier(int n) {
        if (map.get(n + 1) != null) {
            return n + 1;
        }
        return n;
    }

    public static Map<AgentLicenseTier, Integer> getDefaultTierValues() {
        HashMap<AgentLicenseTier, Integer> hashMap = new HashMap<AgentLicenseTier, Integer>();
        for (AgentLicenseTier agentLicenseTier : AgentLicenseTier.values()) {
            hashMap.put(agentLicenseTier, 0);
        }
        return hashMap;
    }

    static {
        map = new HashMap<Integer, AgentLicenseTier>();
        for (AgentLicenseTier agentLicenseTier : AgentLicenseTier.values()) {
            map.put(agentLicenseTier.integerCode, agentLicenseTier);
        }
        codeMap = new HashMap<Character, AgentLicenseTier>();
        for (AgentLicenseTier agentLicenseTier : AgentLicenseTier.values()) {
            codeMap.put(Character.valueOf(agentLicenseTier.characterCode), agentLicenseTier);
        }
    }
}

