/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.xml.XMLSerializable;

public class GenericSortField
extends CommonVersionedObject
implements SortField,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = -1117464512919122626L;
    private int field;
    private int direction;
    private SortField secondarySort;

    public GenericSortField() {
    }

    public GenericSortField(int n, int n2) {
        this.setField(n);
        this.setDirection(n2);
    }

    @Override
    public int getField() {
        return this.field;
    }

    @Override
    public int getDirection() {
        return this.direction;
    }

    @Override
    public boolean isAscending() {
        return this.direction == 0;
    }

    @Override
    public boolean isDescending() {
        return this.direction == 1;
    }

    public void setField(int n) {
        this.field = n;
    }

    public void setDirection(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("The sorting direction " + n + " is not valid.");
        }
        this.direction = n;
    }

    @Override
    public String[] doNotInvoke() {
        return null;
    }

    @Override
    public SortField getSecondarySort() {
        return this.secondarySort;
    }

    public void setSecondarySort(SortField sortField) {
        if (sortField == this) {
            throw new IllegalArgumentException("The sort field passed in is the same as 'this'.");
        }
        this.secondarySort = sortField;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        GenericSortField genericSortField = (GenericSortField)object;
        return super.equals(object) && Equal.isEqual(this.field, genericSortField.field) && Equal.isEqual(this.direction, genericSortField.direction) && Equal.isEqual(this.secondarySort, genericSortField.secondarySort);
    }

    public Object clone() {
        GenericSortField genericSortField;
        try {
            genericSortField = (GenericSortField)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Unable to clone this instance.");
        }
        if (this.secondarySort == null) {
            return genericSortField;
        }
        if (!(this.secondarySort instanceof GenericSortField)) {
            throw new RuntimeException("Unable to clone this instance. Expect secondary sort field to be a GenericSortField.");
        }
        SortField sortField = (SortField)((GenericSortField)this.secondarySort).clone();
        genericSortField.setSecondarySort(sortField);
        return genericSortField;
    }
}

