/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.busobj.Proxy;
import com.helpsystems.common.core.filter.CustomFilterCriteria;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.DataFilterMatcher;
import com.helpsystems.common.core.filter.FilterCriteria;
import java.io.Serializable;
import java.util.Date;
import junit.framework.TestCase;

public class FilterMatcherTest
extends TestCase {
    private Proxy p1;
    private Proxy p2;
    private Proxy p3;
    private Proxy dateProxy;
    private Date then;
    private Date now;
    private Date longAgo;
    private DataFilter bigFilter;
    private DataFilter deepFilter;

    protected void setUp() throws Exception {
        super.setUp();
        this.p1 = new Proxy();
        this.p1.setName("Object 1");
        this.p1.setDescription("Nothing special");
        this.p1.setKey(new Integer(12345));
        this.p1.setProductIIDInt(1);
        this.p2 = new Proxy();
        this.p2.setName("Object 2");
        this.p2.setDescription("Even less special");
        this.p2.setKey(new Integer(234567));
        this.p2.setProductIIDInt(2);
        this.p3 = new Proxy();
        this.p3.setName("Different Name");
        this.p3.setDescription("");
        this.p3.setKey(new Integer(345678));
        this.p3.setProductIIDInt(2);
        this.then = new Date(1234567890000L);
        this.now = new Date();
        this.longAgo = new Date(0L);
        this.dateProxy = new Proxy();
        this.dateProxy.setName("Date proxy");
        this.dateProxy.setDescription("Uses a Date for its Key");
        this.dateProxy.setKey(this.then);
        this.bigFilter = new DataFilter();
        this.bigFilter.setConjunction(0);
        this.bigFilter.addCriteria(new FilterCriteria("getKey", (Serializable)((Object)"0"), 4));
        DataFilter dataFilter = new DataFilter();
        dataFilter.setConjunction(0);
        dataFilter.addCriteria(new FilterCriteria("getName", (Serializable)((Object)"Object"), 9));
        dataFilter.addCriteria(new FilterCriteria("getDescription", (Serializable)((Object)"Object"), 11));
        this.bigFilter.addFilter(dataFilter);
        this.deepFilter = new DataFilter();
        this.deepFilter.setConjunction(0);
        this.deepFilter.addCriteria(new FilterCriteria("getKey", (Serializable)((Object)"0"), 4));
        DataFilter dataFilter2 = new DataFilter();
        dataFilter2.setConjunction(1);
        dataFilter2.addCriteria(new FilterCriteria("getName", (Serializable)((Object)"Object"), 9));
        dataFilter2.addCriteria(new FilterCriteria("getName", (Serializable)((Object)"Diff"), 6));
        DataFilter dataFilter3 = new DataFilter();
        dataFilter3.setConjunction(1);
        dataFilter3.addCriteria(new FilterCriteria("getName", (Serializable)((Object)"1"), 9));
        dataFilter3.addCriteria(new FilterCriteria("getDescription", (Serializable)((Object)"special"), 11));
        DataFilter dataFilter4 = new DataFilter();
        dataFilter4.setConjunction(0);
        dataFilter4.addCriteria(new FilterCriteria("getKey", (Serializable)((Object)"0"), 4));
        DataFilter dataFilter5 = new DataFilter();
        dataFilter5.setConjunction(0);
        dataFilter5.addCriteria(new FilterCriteria("getKey", (Serializable)((Object)"0"), 4));
        DataFilter dataFilter6 = new DataFilter();
        dataFilter6.setConjunction(0);
        dataFilter6.addCriteria(new FilterCriteria("getKey", (Serializable)((Object)"0"), 4));
        DataFilter dataFilter7 = new DataFilter();
        dataFilter7.setConjunction(0);
        dataFilter7.addCriteria(new FilterCriteria("getKey", (Serializable)((Object)"0"), 4));
        dataFilter6.addFilter(dataFilter7);
        dataFilter5.addFilter(dataFilter6);
        dataFilter4.addFilter(dataFilter5);
        dataFilter3.addFilter(dataFilter4);
        dataFilter2.addFilter(dataFilter3);
        this.deepFilter.addFilter(dataFilter2);
    }

    protected void tearDown() throws Exception {
        this.p1 = null;
        this.p2 = null;
        this.p3 = null;
        this.then = null;
        this.now = null;
        this.longAgo = null;
        this.dateProxy = null;
        this.bigFilter = null;
        this.deepFilter = null;
        super.tearDown();
    }

    public void testStringEqual() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getName", (Serializable)((Object)"Object 1"), 0));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p2));
    }

    public void testStringEqualsWithNotConjunction() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.setConjunction(2);
        dataFilter.addCriteria(new FilterCriteria("getName", (Serializable)((Object)"Object 1"), 0));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p2));
    }

    public void testStringEqualIgnoreCase() throws Exception {
        DataFilter dataFilter = new DataFilter();
        FilterCriteria filterCriteria = new FilterCriteria("getName", (Serializable)((Object)"obJEct 1"), 0);
        filterCriteria.setIgnoreCase(true);
        dataFilter.addCriteria(filterCriteria);
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p2));
    }

    public void testStringNotEqual() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getName", (Serializable)((Object)"Object 1"), 1));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p2));
    }

    public void testStringLessThan() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getDescription", (Serializable)((Object)"In Between Value"), 5));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testStringGreaterThan() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getDescription", (Serializable)((Object)"In Between Value"), 4));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testStringContains() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getName", (Serializable)((Object)"Object"), 9));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testStringDoesNotContain() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getName", (Serializable)((Object)"Different"), 11));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testStringStartsWith() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getName", (Serializable)((Object)"Object"), 6));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testStringDoesNotStartWith() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getName", (Serializable)((Object)"Diff"), 10));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testStringIn() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getName", (Serializable)((Object)"Blah,Object 1,Something"), 7));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testStringNotIn() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getName", (Serializable)((Object)"Blah,Object 1,Something"), 8));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testNumberEqual() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getProductIIDInt", Integer.valueOf(1), 0));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testNumberNotEqual() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getProductIIDInt", Integer.valueOf(1), 1));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testNumberIn() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", (Serializable)((Object)"1,2,14,12345,90210,8675309"), 7));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testNumberNotIn() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", (Serializable)((Object)"1,2,14,12345,90210,8675309"), 8));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testNumberLessThan() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", (Serializable)((Object)"99999"), 5));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testNumberLessThanNumeric() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", Integer.valueOf(99999), 5));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testNumberGreaterThan() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", (Serializable)((Object)"100000"), 4));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testNumberGreaterThanNumeric() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", Integer.valueOf(100000), 4));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testDateEquals() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", this.then, 0));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.dateProxy));
    }

    public void testDateEqualsNoMatch() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", this.now, 0));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.dateProxy));
    }

    public void testDateNotEqual() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", this.now, 1));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.dateProxy));
    }

    public void testDateNotEqualNoMatch() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", this.then, 1));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.dateProxy));
    }

    public void testDateLessThanMatch() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", this.now, 5));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.dateProxy));
    }

    public void testDateLessThanNoMatch() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", this.longAgo, 5));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.dateProxy));
    }

    public void testDateGreaterThan() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", this.longAgo, 4));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.dateProxy));
    }

    public void testDateGreaterThanNoMatch() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", this.now, 4));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.dateProxy));
    }

    public void testDateEqualGreaterThan() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", this.longAgo, 2));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.dateProxy));
        dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", this.then, 2));
        dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.dateProxy));
    }

    public void testDateEqualGreaterThanNoMatch() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", this.now, 2));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.dateProxy));
    }

    public void testDateEqualLessThan() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", this.now, 3));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.dateProxy));
        dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", this.then, 3));
        dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.dateProxy));
    }

    public void testDateEqualLessThanNoMatch() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getKey", this.longAgo, 3));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.dateProxy));
    }

    public void testBigFilter() throws Exception {
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(this.bigFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testDeepFilter() throws Exception {
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(this.deepFilter);
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p1));
        FilterMatcherTest.assertEquals((boolean)false, (boolean)dataFilterMatcher.matches(this.p2));
        FilterMatcherTest.assertEquals((boolean)true, (boolean)dataFilterMatcher.matches(this.p3));
    }

    public void testBadFilter() {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getBogus", (Serializable)((Object)"1234"), 0));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        try {
            dataFilterMatcher.matches(this.p1);
            FilterMatcherTest.fail((String)"Filter allowed bogus method name");
        }
        catch (ActionFailedException actionFailedException) {
            // empty catch block
        }
    }

    public void testStaticCompare() throws Exception {
        String string = "abc";
        String string2 = "abc";
        FilterMatcherTest.assertEquals((boolean)true, (boolean)DataFilterMatcher.evaluate(string, string2, 0));
    }

    public void testSetAutoParseNumbers() {
        DataFilter dataFilter = new DataFilter();
        dataFilter.addCriteria(new FilterCriteria("getBogus", (Serializable)((Object)"1234"), 0));
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        dataFilterMatcher.setAutoParseNumbers(false);
        FilterMatcherTest.assertFalse((boolean)dataFilterMatcher.getAutoParseNumbers());
        dataFilterMatcher.setAutoParseNumbers(true);
        FilterMatcherTest.assertTrue((boolean)dataFilterMatcher.getAutoParseNumbers());
    }

    public void testHandleFilterWithNoCriteria() throws Exception {
        DataFilter dataFilter = new DataFilter();
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertTrue((boolean)dataFilterMatcher.matches(this.p1));
    }

    public void testHandleFilterWithCustomCriteria() throws Exception {
        DataFilter dataFilter = new DataFilter();
        dataFilter.setConjunction(2);
        CustomFilterCriteria customFilterCriteria = new CustomFilterCriteria(){

            @Override
            public boolean matches(Object object) {
                return false;
            }
        };
        dataFilter.addCriteria(customFilterCriteria);
        DataFilterMatcher dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertTrue((boolean)dataFilterMatcher.matches(this.p1));
        dataFilter.setConjunction(0);
        dataFilterMatcher = new DataFilterMatcher(dataFilter);
        FilterMatcherTest.assertFalse((boolean)dataFilterMatcher.matches(this.p1));
    }
}

