/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.filter.AbstractFilterField;
import com.helpsystems.common.core.filter.FilterCriteria;
import com.helpsystems.common.core.filter.FilterFieldPackedTimestamp;
import com.helpsystems.common.core.util.Convert;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class FilterFieldPackedTwoFieldTimestamp
extends AbstractFilterField {
    private static final long serialVersionUID = 1472449125915044957L;
    private String[] operators = new String[]{"0", "1", "2", "3", "4", "5"};

    public FilterFieldPackedTwoFieldTimestamp() {
    }

    public FilterFieldPackedTwoFieldTimestamp(String string, String string2, String string3) {
        super(string, string2 + "*1000000+" + string3, 4);
        this.setOperatorArray(this.operators);
    }

    @Override
    public boolean valid(int n, Object object) {
        if (!(object instanceof Date)) {
            throw new IllegalArgumentException("Not a valid date object.");
        }
        return super.valid(n, object);
    }

    @Override
    public FilterCriteria getFilterCriteria(int n, Serializable serializable) {
        this.valid(n, serializable);
        Date date = (Date)serializable;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new FilterCriteria(this.fieldName, FilterFieldPackedTimestamp.getTimestampAsLong(calendar), n);
    }

    @Override
    public Serializable getValueFromCriteria(FilterCriteria filterCriteria) {
        Long l = (Long)filterCriteria.getValue();
        String string = l.toString();
        return Convert.getDate(string).getTime();
    }
}

