/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.filter.AbstractFilterField;
import com.helpsystems.common.core.filter.FilterCriteria;
import com.helpsystems.common.core.util.Convert;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class FilterFieldPackedTime
extends AbstractFilterField {
    private static final long serialVersionUID = -4663058852004712370L;
    private String[] operators = new String[]{"0", "1", "2", "3", "4", "5"};

    public FilterFieldPackedTime() {
    }

    public FilterFieldPackedTime(String string, String string2) {
        super(string, string2, 3);
        this.setOperatorArray(this.operators);
    }

    @Override
    public boolean valid(int n, Object object) {
        if (!(object instanceof Date)) {
            throw new IllegalArgumentException("Not a valid date object.");
        }
        return super.valid(n, object);
    }

    @Override
    public FilterCriteria getFilterCriteria(int n, Serializable serializable) {
        this.valid(n, serializable);
        Date date = (Date)serializable;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new FilterCriteria(this.fieldName, FilterFieldPackedTime.getTimeAsLong(calendar), n);
    }

    @Override
    public Serializable getValueFromCriteria(FilterCriteria filterCriteria) {
        Long l = (Long)filterCriteria.getValue();
        String string = l.toString();
        if (string.length() < "hhmmss".length()) {
            switch ("hhmmss".length() - string.length()) {
                case 1: {
                    string = "0" + l.toString();
                    break;
                }
                case 2: {
                    string = "00" + l.toString();
                    break;
                }
                case 3: {
                    string = "000" + l.toString();
                }
            }
        }
        return Convert.getDate("1010101" + string).getTime();
    }

    public static Long getTimeAsLong(Calendar calendar) {
        String string = Convert.getDateString(calendar);
        return Long.valueOf(string.substring(7, 13));
    }
}

