/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.filter.AbstractFilterField;
import com.helpsystems.common.core.filter.FilterCriteria;
import com.helpsystems.common.core.util.Convert;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class FilterFieldPackedDate
extends AbstractFilterField {
    private static final long serialVersionUID = -2498837073432416675L;
    private String[] operators = new String[]{"0", "1", "2", "3", "4", "5"};

    public FilterFieldPackedDate() {
    }

    public FilterFieldPackedDate(String string, String string2) {
        super(string, string2, 2);
        this.setOperatorArray(this.operators);
    }

    @Override
    public boolean valid(int n, Object object) {
        if (!(object instanceof Date)) {
            throw new IllegalArgumentException("Not a valid date object.");
        }
        return super.valid(n, object);
    }

    @Override
    public FilterCriteria getFilterCriteria(int n, Serializable serializable) {
        this.valid(n, serializable);
        Date date = (Date)serializable;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new FilterCriteria(this.fieldName, FilterFieldPackedDate.getDateAsLong(calendar), n);
    }

    @Override
    public Serializable getValueFromCriteria(FilterCriteria filterCriteria) {
        Long l = (Long)filterCriteria.getValue();
        String string = l.toString();
        return Convert.getDate(string + "000000").getTime();
    }

    public static Long getDateAsLong(Calendar calendar) {
        String string = Convert.getDateString(calendar);
        return Long.valueOf(string.substring(0, 7));
    }
}

