/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.filter.FilterCriteria;
import junit.framework.TestCase;

public class FilterCriteriaTest
extends TestCase {
    static final int OPERATOR_BOGUS = -298348;
    FilterCriteria fc;

    protected void setUp() throws Exception {
        super.setUp();
        this.fc = new FilterCriteria();
    }

    protected void tearDown() throws Exception {
        this.fc = null;
        super.tearDown();
    }

    public void testConstructor() {
        this.fc = new FilterCriteria("field_name", new Long(12345L), 0);
        FilterCriteriaTest.assertEquals((String)"field_name", (String)this.fc.getFieldName());
        FilterCriteriaTest.assertEquals((Object)new Long(12345L), (Object)this.fc.getValue());
        FilterCriteriaTest.assertEquals((int)0, (int)this.fc.getOperator());
    }

    public void testConstructorInvalidOperator() {
        try {
            this.fc = new FilterCriteria("field_name", new Long(12345L), -298348);
            FilterCriteriaTest.fail((String)"Constructor accepted an invalid operator");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetIgnoreCase() {
        this.fc.setIgnoreCase(true);
        FilterCriteriaTest.assertTrue((boolean)this.fc.isIgnoreCase());
        this.fc.setIgnoreCase(false);
        FilterCriteriaTest.assertFalse((boolean)this.fc.isIgnoreCase());
    }

    public void testIsDynamicFilter() {
        FilterCriteriaTest.assertFalse((boolean)this.fc.isDynamicFilter());
    }

    public void testDoNotInvoke() {
        String[] stringArray = this.fc.doNotInvoke();
        FilterCriteriaTest.assertNull((Object)stringArray);
    }

    public void testGetFieldName() {
        this.fc.setFieldName("field_name");
        FilterCriteriaTest.assertEquals((String)"field_name", (String)this.fc.getFieldName());
    }

    public void testGetValue() {
        Long l = new Long(12345L);
        this.fc.setValue(l);
        FilterCriteriaTest.assertEquals((Object)l, (Object)this.fc.getValue());
    }

    public void testGetOperator() {
        this.fc.setOperator(0);
        FilterCriteriaTest.assertEquals((int)0, (int)this.fc.getOperator());
        this.fc.setOperator(5);
        FilterCriteriaTest.assertEquals((int)5, (int)this.fc.getOperator());
        this.fc.setOperator(9);
        FilterCriteriaTest.assertEquals((int)9, (int)this.fc.getOperator());
        this.fc.setOperator(-298348);
        FilterCriteriaTest.assertEquals((int)-298348, (int)this.fc.getOperator());
    }

    public void testGetProtectedCriteria() {
        this.fc.setProtectedCriteria(true);
        FilterCriteriaTest.assertTrue((boolean)this.fc.getProtectedCriteria());
        FilterCriteriaTest.assertTrue((boolean)this.fc.isProtectedCriteria());
        this.fc.setProtectedCriteria(false);
        FilterCriteriaTest.assertFalse((boolean)this.fc.getProtectedCriteria());
        FilterCriteriaTest.assertFalse((boolean)this.fc.isProtectedCriteria());
    }

    public void testGetProtectedText() {
        this.fc.setProtectedText("protected_text");
        FilterCriteriaTest.assertEquals((String)"protected_text", (String)this.fc.getProtectedText());
    }
}

