/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.filter.AbstractFilterField;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.XMLSerializable;
import java.io.Serializable;

public class FilterCriteria
extends CommonVersionedObject
implements XMLSerializable {
    private static final long serialVersionUID = -1243960848780340440L;
    private String fieldName;
    private Serializable value;
    private boolean ignoreCase = false;
    private int operator;
    private boolean protectedCriteria = false;
    private String protectedText = null;
    private boolean isValueAField;

    public FilterCriteria() {
    }

    public FilterCriteria(String string, Serializable serializable, int n) {
        ValidationHelper.checkForNullAndBlank(string, "Field Name");
        if (!AbstractFilterField.isValidOperator(n)) {
            throw new IllegalArgumentException("Operator " + n + " is not valid.");
        }
        this.fieldName = string;
        this.value = serializable;
        this.operator = n;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isDynamicFilter() {
        return false;
    }

    @Override
    public String[] doNotInvoke() {
        return null;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Serializable getValue() {
        return this.value;
    }

    public int getOperator() {
        return this.operator;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public void setValue(Serializable serializable) {
        this.value = serializable;
    }

    public void setOperator(int n) {
        this.operator = n;
    }

    public boolean getProtectedCriteria() {
        return this.isProtectedCriteria();
    }

    public boolean isProtectedCriteria() {
        return this.protectedCriteria;
    }

    public void setProtectedCriteria(boolean bl) {
        this.protectedCriteria = bl;
    }

    public String getProtectedText() {
        return this.protectedText;
    }

    public void setProtectedText(String string) {
        this.protectedText = string;
    }

    public boolean isValueAField() {
        return this.isValueAField;
    }

    public boolean getIsValueAField() {
        return this.isValueAField;
    }

    public void setIsValueAField(boolean bl) {
        this.isValueAField = bl;
    }
}

