/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.filter.CustomFilterCriteria;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.FilterCriteria;
import com.helpsystems.common.core.filter.MatcherValueProvider;
import com.helpsystems.common.core.filter.ReflectionValueProvider;
import com.helpsystems.common.core.util.ValidationHelper;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DataFilterMatcher {
    private DataFilter filter;
    private Map<DataFilter, DataFilterMatcher> matcherMap;
    private MatcherValueProvider valueProvider;
    private boolean autoParseNumbers = true;

    public DataFilterMatcher(DataFilter dataFilter) {
        ValidationHelper.checkForNull("Filter", dataFilter);
        this.filter = dataFilter;
        DataFilter[] dataFilterArray = dataFilter.getFilters();
        if (dataFilterArray == null) {
            return;
        }
        this.matcherMap = new HashMap<DataFilter, DataFilterMatcher>();
        for (DataFilter dataFilter2 : dataFilterArray) {
            this.matcherMap.put(dataFilter2, new DataFilterMatcher(dataFilter2));
        }
        this.valueProvider = new ReflectionValueProvider();
    }

    public boolean matches(Object object) throws ActionFailedException {
        FilterCriteria[] filterCriteriaArray;
        DataFilter[] dataFilterArray = this.filter.getFilters();
        if (dataFilterArray != null && dataFilterArray.length > 0) {
            for (DataFilter object2 : dataFilterArray) {
                DataFilterMatcher dataFilterMatcher = this.matcherMap.get(object2);
                if (dataFilterMatcher.matches(object)) continue;
                return false;
            }
        }
        boolean bl = false;
        int n = this.filter.getConjunction();
        for (FilterCriteria filterCriteria : filterCriteriaArray = this.filter.getCriteria()) {
            boolean bl2;
            if (filterCriteria instanceof CustomFilterCriteria) {
                bl2 = ((CustomFilterCriteria)filterCriteria).matches(object);
            } else {
                Object object2 = this.retrieveValue(filterCriteria, object);
                bl2 = DataFilterMatcher.evaluateValue(filterCriteria, object2, this.autoParseNumbers);
            }
            if (!bl2) {
                if (n != 0) continue;
                return false;
            }
            if (n == 2) {
                return false;
            }
            bl = true;
        }
        return n != 1 || bl;
    }

    public boolean getAutoParseNumbers() {
        return this.autoParseNumbers;
    }

    public void setAutoParseNumbers(boolean bl) {
        this.autoParseNumbers = bl;
    }

    private Object retrieveValue(FilterCriteria filterCriteria, Object object) throws ActionFailedException {
        return this.valueProvider.retrieveValue(filterCriteria, object);
    }

    public MatcherValueProvider getValueProvider() {
        return this.valueProvider;
    }

    public void setValueProvider(MatcherValueProvider matcherValueProvider) {
        this.valueProvider = matcherValueProvider;
        for (DataFilterMatcher dataFilterMatcher : this.matcherMap.values()) {
            dataFilterMatcher.setValueProvider(matcherValueProvider);
        }
    }

    private static boolean evaluateValue(FilterCriteria filterCriteria, Object object, boolean bl) {
        int n;
        if (filterCriteria instanceof CustomFilterCriteria) {
            return ((CustomFilterCriteria)filterCriteria).matches(object);
        }
        Serializable serializable = filterCriteria.getValue();
        String string = serializable.toString();
        int n2 = filterCriteria.getOperator();
        if (object == null) {
            if (serializable instanceof String) {
                object = "";
            } else if (serializable instanceof Number) {
                object = new Integer(0);
            } else {
                throw new NullPointerException("Unable to compare null value.");
            }
        }
        String string2 = object.toString();
        if (filterCriteria.isIgnoreCase()) {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (n2 == 9) {
            return string2.indexOf(string) > -1;
        }
        if (n2 == 11) {
            return string2.indexOf(string) == -1;
        }
        if (n2 == 10) {
            return !string2.startsWith(string);
        }
        if (n2 == 6) {
            return string2.startsWith(string);
        }
        if (n2 == 7 || n2 == 8) {
            String[] stringArray;
            for (String string3 : stringArray = string.split(",")) {
                if (!(string3 = string3.trim()).equals(string2)) continue;
                return n2 == 7;
            }
            return n2 != 7;
        }
        if (bl && (object instanceof Number || serializable instanceof Number)) {
            if (!(object instanceof Number)) {
                try {
                    double d = Double.parseDouble(string2.trim());
                    object = new Double(d);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!(serializable instanceof Number)) {
                try {
                    double d = Double.parseDouble(string.trim());
                    serializable = new Double(d);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (object instanceof Number && serializable instanceof Number) {
            Number number = (Number)object;
            Number number2 = (Number)serializable;
            Double d = new Double(number.doubleValue());
            Double d2 = new Double(number2.doubleValue());
            n = d.compareTo(d2);
        } else if (object instanceof Character && serializable instanceof Character) {
            Character c = (Character)object;
            Character c2 = (Character)serializable;
            n = c.compareTo(c2);
        } else if (object instanceof Date && serializable instanceof Date) {
            Date date = (Date)object;
            Date date2 = (Date)serializable;
            n = date.compareTo(date2);
        } else {
            n = string2.compareTo(string);
        }
        if (n2 == 2) {
            return n >= 0;
        }
        if (n2 == 3) {
            return n <= 0;
        }
        if (n2 == 0) {
            return n == 0;
        }
        if (n2 == 4) {
            return n > 0;
        }
        if (n2 == 5) {
            return n < 0;
        }
        if (n2 == 1) {
            return n != 0;
        }
        throw new IllegalArgumentException("Unknown operator: " + n2);
    }

    public static boolean evaluate(String string, String string2, int n) {
        FilterCriteria filterCriteria = new FilterCriteria("temp", (Serializable)((Object)string), n);
        return DataFilterMatcher.evaluateValue(filterCriteria, string2, true);
    }
}

