/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.filter.FilterCriteria;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.core.xml.XMLSerializable;
import java.util.ArrayList;
import java.util.Comparator;

public class DataFilter
extends CommonVersionedObject
implements XMLSerializable,
Cloneable {
    private static final long serialVersionUID = -1715088020971492231L;
    public static final Comparator<DataFilter> NAME_COMPARATOR = new DataFilterComparator();
    public static final int CONJUNCTION_AND = 0;
    public static final int CONJUNCTION_OR = 1;
    public static final int CONJUNCTION_NOT = 2;
    public static final int MAXIMUM_DATAFILTER_NAME = 50;
    private ArrayList<FilterCriteria> criteriaList;
    private ArrayList<DataFilter> filterList;
    private int conjunction = 0;
    private String dataFilterName = "";
    private String groupName = null;
    private String sql = null;

    public DataFilter() {
        this("Unknown");
    }

    public DataFilter(String string) {
        this.setDataFilterName(string);
        this.criteriaList = new ArrayList();
        this.filterList = new ArrayList();
    }

    public boolean hasDynamicFilterCriteria() {
        if (!this.criteriaList.isEmpty() || !this.filterList.isEmpty()) {
            int n;
            for (n = 0; n < this.criteriaList.size(); ++n) {
                if (!this.criteriaList.get(n).isDynamicFilter()) continue;
                return true;
            }
            for (n = 0; n < this.filterList.size(); ++n) {
                if (!this.filterList.get(n).hasDynamicFilterCriteria()) continue;
                return true;
            }
        }
        return false;
    }

    public DataFilter(int n, FilterCriteria[] filterCriteriaArray) {
        this();
        if (filterCriteriaArray != null) {
            for (int i = 0; i < filterCriteriaArray.length; ++i) {
                this.addCriteria(filterCriteriaArray[i]);
            }
        }
        this.conjunction = n;
    }

    public Object clone() {
        return XMLReflector.copy(this);
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    public boolean equalsName(DataFilter dataFilter) {
        if (dataFilter == null) {
            return false;
        }
        return Equal.isEqual(this.dataFilterName, dataFilter.dataFilterName);
    }

    public boolean isEmpty() {
        return this.criteriaList.isEmpty() & this.filterList.isEmpty() & !this.hasSQLString();
    }

    public void addCriteria(FilterCriteria filterCriteria) {
        ValidationHelper.checkForNull("Filter Criteria", filterCriteria);
        this.criteriaList.add(filterCriteria);
    }

    public void addFilter(DataFilter dataFilter) {
        ValidationHelper.checkForNull("Filter", dataFilter);
        this.filterList.add(dataFilter);
    }

    @Override
    public String[] doNotInvoke() {
        return null;
    }

    public FilterCriteria[] getCriteria() {
        FilterCriteria[] filterCriteriaArray = new FilterCriteria[this.criteriaList.size()];
        this.criteriaList.toArray(filterCriteriaArray);
        return filterCriteriaArray;
    }

    public DataFilter[] getFilters() {
        DataFilter[] dataFilterArray = new DataFilter[this.filterList.size()];
        this.filterList.toArray(dataFilterArray);
        return dataFilterArray;
    }

    public FilterCriteria getCriteria(int n) {
        return this.criteriaList.get(n);
    }

    public DataFilter getFilter(int n) {
        return this.filterList.get(n);
    }

    public int criteriaSize() {
        return this.criteriaList.size();
    }

    public int filterSize() {
        return this.filterList.size();
    }

    public int getConjunction() {
        return this.conjunction;
    }

    public void setConjunction(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Value for conjunction invalid.");
        }
        this.conjunction = n;
    }

    public void setDataFilterName(String string) {
        ValidationHelper.checkForNull("Filter Name", string);
        ValidationHelper.validateLength("dataFilterName", 50, string);
        this.dataFilterName = string;
    }

    public String getDataFilterName() {
        return this.dataFilterName;
    }

    public String getGroup() {
        return this.groupName;
    }

    public void setGroup(String string) {
        ValidationHelper.checkForNull("Group Name", string);
        this.groupName = string;
    }

    public void setSQLString(String string) {
        this.sql = string;
    }

    public String getSQLString() {
        return this.sql;
    }

    public boolean hasSQLString() {
        return this.sql != null;
    }

    public String toString() {
        return this.dataFilterName;
    }

    static class DataFilterComparator
    implements Comparator<DataFilter> {
        DataFilterComparator() {
        }

        @Override
        public int compare(DataFilter dataFilter, DataFilter dataFilter2) {
            String string;
            String string2 = dataFilter.getDataFilterName().toUpperCase();
            if (string2 == (string = dataFilter2.getDataFilterName().toUpperCase())) {
                return 0;
            }
            if (string2 == null) {
                return -1;
            }
            return string2.compareTo(string);
        }
    }
}

