/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.filter.FilterCriteria;
import com.helpsystems.common.core.filter.FilterField;
import com.helpsystems.common.core.filter.FilterFieldEditDecorator;
import com.helpsystems.common.core.util.Equal;
import java.io.Serializable;
import java.util.Comparator;

public abstract class AbstractFilterField
extends CommonVersionedObject
implements FilterField {
    private static final long serialVersionUID = 6078500816837643907L;
    public static final Comparator<FilterField> DISPLAY_NAME_COMPARATOR = new FilterFieldComparator();
    protected String fieldName;
    protected String displayName;
    protected String[] operatorNames;
    protected int uiType;
    protected FilterFieldEditDecorator filterFieldEditDecorator = null;

    protected AbstractFilterField() {
    }

    public AbstractFilterField(String string, String string2, int n) {
        this.checkForNullAndBlank(string2, "Field Name");
        this.checkForNullAndBlank(string, "Display Name");
        if (!this.isUITypeValid(n)) {
            throw new IllegalArgumentException("UIType is not valid.");
        }
        this.fieldName = string2;
        this.displayName = string;
        this.uiType = n;
    }

    private void checkForNullAndBlank(String string, String string2) throws IllegalArgumentException, NullPointerException {
        if (string == null) {
            throw new NullPointerException(string2 + " may not be null.");
        }
        if (string.trim().length() == 0) {
            throw new IllegalArgumentException(string2 + " may not be blank.");
        }
    }

    @Override
    public String[] getOperatorArray() {
        return this.operatorNames;
    }

    protected void setOperatorArray(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("Operator array may not be null.");
        }
        this.operatorNames = stringArray;
    }

    @Override
    public boolean doesFieldNameMatch(String string) {
        return string.trim().equals(this.fieldName.trim());
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof AbstractFilterField)) {
            return false;
        }
        AbstractFilterField abstractFilterField = (AbstractFilterField)object;
        return super.equals(object) && Equal.isEqual(this.displayName, abstractFilterField.displayName);
    }

    @Override
    public int getStringCase() {
        return 0;
    }

    @Override
    public FilterCriteria getFilterCriteria(int n, Serializable serializable) {
        this.valid(n, serializable);
        return new FilterCriteria(this.fieldName, serializable, n);
    }

    @Override
    public Serializable getValueFromCriteria(FilterCriteria filterCriteria) {
        return filterCriteria.getValue();
    }

    @Override
    public int getUIType() {
        return this.uiType;
    }

    protected boolean isUITypeValid(int n) {
        return n == 0 || n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 6;
    }

    public static boolean isValidOperator(int n) {
        return n == 0 || n == 1 || n == 2 || n == 3 || n == 4 || n == 5 || n == 6 || n == 9 || n == 7 || n == 8 || n == 10 || n == 11;
    }

    @Override
    public void setFilterFieldEditDecorator(FilterFieldEditDecorator filterFieldEditDecorator) {
        this.filterFieldEditDecorator = filterFieldEditDecorator;
    }

    @Override
    public FilterFieldEditDecorator getFilterFieldEditDecorator() {
        return this.filterFieldEditDecorator;
    }

    @Override
    public boolean valid(int n, Object object) {
        if (this.filterFieldEditDecorator != null) {
            return this.filterFieldEditDecorator.validateValue(this, n, object);
        }
        return true;
    }

    @Override
    public Object getMassagedValue(Object object) {
        if (this.filterFieldEditDecorator != null) {
            return this.filterFieldEditDecorator.massageValue(this, object);
        }
        return object;
    }

    static class FilterFieldComparator
    implements Comparator<FilterField> {
        FilterFieldComparator() {
        }

        @Override
        public int compare(FilterField filterField, FilterField filterField2) {
            String string = filterField.getDisplayName();
            String string2 = filterField2.getDisplayName();
            if (string == null) {
                if (string2 == null) {
                    return 0;
                }
                return 1;
            }
            return string.compareTo(string2);
        }
    }
}

