/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.filter;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.filter.SortField;
import com.helpsystems.common.core.util.Equal;
import com.helpsystems.common.core.xml.XMLSerializable;

public class AbsoluteSortField
extends CommonVersionedObject
implements SortField,
XMLSerializable,
Cloneable {
    private static final long serialVersionUID = -1117464512919122629L;
    private String fieldName;
    private int direction;
    private AbsoluteSortField secondarySort;

    public AbsoluteSortField() {
    }

    public AbsoluteSortField(String string, int n) {
        this.setFieldName(string);
        this.setDirection(n);
    }

    @Override
    public int getField() {
        return -1;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public int getDirection() {
        return this.direction;
    }

    @Override
    public boolean isAscending() {
        return this.direction == 0;
    }

    @Override
    public boolean isDescending() {
        return this.direction == 1;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public void setDirection(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("The sorting direction " + n + " is not valid.");
        }
        this.direction = n;
    }

    @Override
    public String[] doNotInvoke() {
        return null;
    }

    @Override
    public AbsoluteSortField getSecondarySort() {
        return this.secondarySort;
    }

    public void setSecondarySort(AbsoluteSortField absoluteSortField) {
        if (absoluteSortField == this) {
            throw new IllegalArgumentException("The sort field passed in is the same as 'this'.");
        }
        this.secondarySort = absoluteSortField;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        AbsoluteSortField absoluteSortField = (AbsoluteSortField)object;
        return super.equals(object) && Equal.isEqual(this.fieldName, absoluteSortField.fieldName) && Equal.isEqual(this.direction, absoluteSortField.direction) && Equal.isEqual(this.secondarySort, absoluteSortField.secondarySort);
    }

    public Object clone() {
        AbsoluteSortField absoluteSortField;
        try {
            absoluteSortField = (AbsoluteSortField)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Unable to clone this instance.");
        }
        if (this.secondarySort == null) {
            return absoluteSortField;
        }
        if (!(this.secondarySort instanceof AbsoluteSortField)) {
            throw new RuntimeException("Unable to clone this instance. Expect secondary sort field to be a AbsoluteSortField.");
        }
        AbsoluteSortField absoluteSortField2 = (AbsoluteSortField)this.secondarySort.clone();
        absoluteSortField.setSecondarySort(absoluteSortField2);
        return absoluteSortField;
    }
}

